function drawAircraft(uu,V,F,patchcolors)

    % process inputs to function
    pn       = uu(1);       % inertial North position     
    pe       = uu(2);       % inertial East position
    pd       = uu(3);           
    u        = uu(4);       
    v        = uu(5);       
    w        = uu(6);       
    phi      = uu(7);       % roll angle         
    theta    = uu(8);       % pitch angle     
    psi      = uu(9);       % yaw angle     
    p        = uu(10);       % roll rate
    q        = uu(11);       % pitch rate     
    r        = uu(12);       % yaw rate    
    t        = uu(13);       % time

    % define persistent variables 
    persistent vehicle_handle;
    persistent Vertices
    persistent Faces
    persistent facecolors
    
    % first time function is called, initialize plot and persistent vars
    coeff = 1000;
    %coeff = 10; %norm
    
    
    
    if t==0,
        figure(1), clf
        [Vertices,Faces,facecolors] = defineVehicleBody;
        vehicle_handle = drawVehicleBody(Vertices,Faces,facecolors,...
                                               pn,pe,pd,phi,theta,psi,...
                                               [],'normal');
        title('Vehicle')
        xlabel('East')
        ylabel('North')
        zlabel('-Down')
        view(32,47)  % set the vieew angle for figure
        axis([-10*coeff,10*coeff,-10*coeff,10*coeff,-10*coeff,10*coeff]);
        %axis([-1*coeff,11*coeff,-10*coeff,10*coeff,0*coeff,10*coeff]); %norm
        hold on
        
        %frame = getframe(1);
        %im = frame2im(frame);
        %[A,map] = rgb2ind(im,256);
        
        %imwrite(A,map,'C1.gif','gif', 'Loopcount',Inf,'DelayTime',1/24);
        
    % at every other time step, redraw base and rod
    else 
        drawVehicleBody(Vertices,Faces,facecolors,...
                           pn,pe,pd,phi,theta,psi,...
                           vehicle_handle);
                      
        %frame = getframe(1);
        %im = frame2im(frame);
        %[A,map] = rgb2ind(im,256);
                       
        %imwrite(A,map,'C1.gif','gif','WriteMode','append','DelayTime',1/24);
    end
end

  
%=======================================================================
% drawVehicle
% return handle if 3rd argument is empty, otherwise use 3rd arg as handle
%=======================================================================
%
function handle = drawVehicleBody(V,F,patchcolors,...
                                     pn,pe,pd,phi,theta,psi,...
                                     handle,mode)
                                 
                                 
  
                                 
  V = rotate(V, phi, theta, psi);  % rotate vehicle
  V = translate(V, pn, pe, pd);  % translate vehicle
  % transform vertices from NED to XYZ (for matlab rendering)
  R = [...
      0, 1, 0;...
      1, 0, 0;...
      0, 0, -1;...
      ];
  V = R*V;
  
  if isempty(handle),
  handle = patch('Vertices', V', 'Faces', F,...
                 'FaceVertexCData',patchcolors,...
                 'FaceColor','flat',...
                 'EraseMode', mode);
  else
    set(handle,'Vertices',V','Faces',F);
    drawnow
  end
end

%%%%%%%%%%%%%%%%%%%%%%%
function pts=rotate(pts,phi,theta,psi)

  % define rotation matrix (right handed)
  R_roll = [...
          1, 0, 0;...
          0, cos(phi), sin(phi);...
          0, -sin(phi), cos(phi)];
  R_pitch = [...
          cos(theta), 0, -sin(theta);...
          0, 1, 0;...
          sin(theta), 0, cos(theta)];
  R_yaw = [...
          cos(psi), sin(psi), 0;...
          -sin(psi), cos(psi), 0;...
          0, 0, 1];
  R = R_roll*R_pitch*R_yaw;  
    % note that R above either leaves the vector alone or rotates
    % a vector in a left handed rotation.  We want to rotate all
    % points in a right handed rotation, so we must transpose
  R = R';

  % rotate vertices
  pts = R*pts;
  
end
% end rotateVert

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% translate vertices by pn, pe, pd
function pts = translate(pts,pn,pe,pd)

  pts = pts + repmat([pn;pe;pd],1,size(pts,2));
  
end

% end translate


%=======================================================================
% defineVehicleBody
%=======================================================================
function [V,F,facecolors] = defineVehicleBody

V2 = [...
    -1,     0, 0-0.18;... % 1
    -1,     0.3, 0-0.18;... % 2
    -0.8,   0.3, 0-0.18;... % 3
    -0.75,  0.02, 0-0.18;... % 4
    0,      0.1, 0;... % 5
    0.2,    1, -0.1;... % 6
    0.35,   1, -0.1;... % 7
    0.45,   0.15, 0;... % 8
    0.8,    0.1, 0;... % 9
    0.85,      0.05, -0.05;... % 10
    0.85,      -0.05, -0.05;... % 11
    0.8,    -0.1, 0;... % 12
    0.45,   -0.15, 0;... % 13
    0.35,   -1, -0.1;... % 14
    0.2,    -1, -0.1;... % 15
    0,      -0.1, 0;... % 16
    -0.75,  -0.02, 0-0.18;... % 17
    -0.8,   -0.3, 0-0.18;... % 18
    -1,     -0.3, 0-0.18;... % 19

    -0.75,  0.02,   -0.05-0.18;... % 20 4_1
    -0.75,  -0.02,  -0.05-0.18;... % 21 17_1
    -1,     0,      -0.05-0.18;... % 22 1_1
    
    0,      0.07,    -0.25;... % 23
    0.25,   0.07,    -0.25;... % 24
    0.27,   0.07,    -0.20;... % 25
    0.45,	0.07,    -0.20;... % 26  
    0.8,    0.07,    -0.15;... % 27
    0.8,    -0.07,   -0.15;... % 28
    0.45,   -0.07,   -0.20;... % 29
    0.27,	-0.07,   -0.20;... % 30
    0.25,   -0.07,   -0.25;... % 31
    0,      -0.07,   -0.25;... % 32
    
    -0.79,      0,   -0.45;... % 33
    -0.86,     0,   -0.45;... % 34
    
    0,      0.08, -0.05;... % 35 5_1
    0.45,   0.13, -0.05;... % 36 8_1
    0.45,   -0.13, -0.05;... % 37 13_1
    0,      -0.08, -0.05;... % 38 16_1
    
    0.85,      0.05, -0.1;... % 39 10_1
    0.85,      -0.05, -0.1;... % 40 11_1
    
    ]';

F = [...
        1,  2,  3,  4;...  %1
        1,  17,  18,	19;...  %2
        4,  5,  16,	17;... %3
        5,  6,	7,  8;... %4
        5,  8,  13, 16;... %5
        13, 14,	15,	16;... %6
        8,  9,	12, 13;... %7
        9,  10,	11,	12;... %8
        
        22,  2,  3,  20;... %9
        22,  19,  18,  21;... %10
        
        22, 20, 33, 34;... %11
        22, 21, 33, 34;... %12
        20, 21, 33, 33;... %13
        
        21, 20, 23, 32;... % 14 3_1
        23,	24,	31,	32;... % 15 6_1
        24,	25,	30,	31;... % 16 6_2
        25,	26,	29,	30;... % 17 6_3
        26,	27,	28,	29;... % 18 7_1
        
        4, 20, 23, 5;... %
        5, 25, 24, 23;... %sdfsdfsdfsdfsdf
        5, 8, 26, 23;... %sdfsdfsdfsdfsdf
        8, 9, 27, 26;... %
        
        17, 21, 32, 16;... %
        16, 32, 31, 30;... %sdfsdfsdfsdfsdf
        30, 29, 13, 16;... %sdfsdfsdfsdfsdf
        13, 29, 28, 12;... %
        
        6, 7, 36, 35;... %
        14, 15, 38, 37;... %
        
        10,11,40,39;... %
        9,10,39,27;... %
        11,12,28,40;... %
        28,27,39,40;... %
        
        3,4,20,20;...%
        18,17,21,21;...%
        
        7,8,36,36;...%
        13,14,37,37;...%
        ];

  myred = [1, 0, 0];
  mygreen = [0.7, 1, 0.7];
  myblue = [0, 0, 1];
  myyellow = [1, 1, 0];
  mycyan = [0, 1, 1];
    
 facecolors = [...
    myblue;...    % left wing
    myblue;...    % right wing
    myblue;...    % main
    myblue;...    % tail
    myblue;...    % right wing
    myblue;...    % right wing
    myblue;...    % 
    myyellow;...    % 
    
    mygreen;...    % 
    mygreen;...    %
    
    myred;...
    myred;...
    myred;...
    
    mygreen;...    % 
    mygreen;...    % 
    mycyan;...    %
    mygreen;...    % 
    mygreen;...    %
    
    mygreen;...    %
    mygreen;...    %
    mygreen;...    %
    mygreen;...    %
    
    mygreen;...    %
    mygreen;...    %
    mygreen;...    %
    mygreen;...    %
    
    mygreen;...    % 
    mygreen;...    %
    
    myyellow;...    % 
    myyellow;...    % 
    myyellow;...    % 
    myyellow;...    % 
    
    mygreen;...    % 
    mygreen;...    %
    
    mygreen;...    % 
    mygreen;...    %
    ];
    
%{
V2 = [...
    0, -2, 0;...   % pt 1
    3, 0, 0;... % pt 2
    1, -0.5, 0;...   % pt 3
    0, -0.5, 0;...  % pt 4
    -2, -0.2, 0;...  % pt 5
    1, 0.5, 0;...   % pt 6
    0, 0.5, 0;... % pt 7
    -2, 0.2, 0;...   % pt 8
    0, 2, 0;...  % pt 9
    
    -2, 0, 0;... % pt 10
    -1, 0, 0;...   % pt 11
    -2, 0, -1;...  % pt 12
    
    1, -0.5, -0.1;... % pt 13 new 3
    0, -0.5, -0.1;...   % pt 14 new 4
    
    1, 0.5, -0.1;...  % pt 15 new 6
    0, 0.5, -0.1;...  % pt 16 new 7
    ]';
%}
V = V2 * 3800;
%V = V2; %norm
% define faces as a list of vertices numbered above
  


%{

F = [...
        1, 3, 4, 4, 4, 4, 4;...  % left wing
        6, 7, 9, 9, 9, 9, 9;...  % right wing
        2, 3, 4, 5, 8, 7, 6;... % main 1
        10, 11, 12, 12, 12, 12, 12;... % tail
        1, 13, 14, 14, 14, 14, 14;... % left wing 2
        9, 15, 16, 16, 16, 16, 16;... % right wing 2
        13, 14, 16, 15, 15, 15, 15;... % 
        1, 9, 16, 14, 14, 14, 14;... % 
        1, 3, 6, 9, 15, 13, 13;... % 
        %2, 4, 5;... % main 2 
        %2, 5, 8;... % main 3
        %2, 8, 7;... % main 4
        %2, 7, 6;... % main 5
        ];

%}

% define colors for each face    

%{
  facecolors = [...
    myblue;...    % left wing
    myblue;...    % right wing
    myblue;...    % main
    myred;...    % tail
    mygreen;...    % right wing
    mygreen;...    % right wing
    mygreen;...    % 
    mygreen;...    % 
    mygreen;...    % 
    %myblue;...    % main
    %myblue;...    % main
   % myblue;...    % main
    %myblue;...    % main
    ];
%}
  
% Define the vertices (physical location of vertices
%{
V = [...
    1, 0, 0;...   % pt 1
    -1, -2, 0;... % pt 2
    0, 0, 0;...   % pt 3
    -1, 2, 0;...  % pt 4
    0, 0, -2;...  % pt 5
    ]';

% define faces as a list of vertices numbered above
  F = [...
        1, 2, 3;...  % left wing
        1, 3, 4;...  % right wing
        1, 3, 5;...  % tail 
        ];

% define colors for each face    
  myred = [1, 0, 0];
  mygreen = [0.7, 1, 0.7];
  myblue = [0, 0, 1];
  myyellow = [1, 1, 0];
  mycyan = [0, 1, 1];

  facecolors = [...
    mygreen;...    % left wing
    mygreen;...    % right wing
    myblue;...     % tail
    ];
%}
end