function [sys,x0,str,ts,simStateCompliance] = mav_dynamics(t,x,u,flag,P)

switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
    [sys,x0,str,ts,simStateCompliance]=mdlInitializeSizes(P);

  %%%%%%%%%%%%%%%
  % Derivatives %
  %%%%%%%%%%%%%%%
  case 1,
    sys=mdlDerivatives(t,x,u,P);

  %%%%%%%%%%
  % Update %
  %%%%%%%%%%
  case 2,
    sys=mdlUpdate(t,x,u);

  %%%%%%%%%%%
  % Outputs %
  %%%%%%%%%%%
  case 3,
    sys=mdlOutputs(t,x,u);

  %%%%%%%%%%%%%%%%%%%%%%%
  % GetTimeOfNextVarHit %
  %%%%%%%%%%%%%%%%%%%%%%%
  case 4,
    sys=mdlGetTimeOfNextVarHit(t,x,u);

  %%%%%%%%%%%%%
  % Terminate %
  %%%%%%%%%%%%%
  case 9,
    sys=mdlTerminate(t,x,u);

  %%%%%%%%%%%%%%%%%%%%
  % Unexpected flags %
  %%%%%%%%%%%%%%%%%%%%
  otherwise
    DAStudio.error('Simulink:blocks:unhandledFlag', num2str(flag));

end

% end sfuntmpl

%
%=============================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=============================================================================
%
function [sys,x0,str,ts,simStateCompliance]=mdlInitializeSizes(P)

%
% call simsizes for a sizes structure, fill it in and convert it to a
% sizes array.
%
% Note that in this example, the values are hard coded.  This is not a
% recommended practice as the characteristics of the block are typically
% defined by the S-function parameters.
%
sizes = simsizes;

sizes.NumContStates  = 12;
sizes.NumDiscStates  = 0;
sizes.NumOutputs     = 12;
sizes.NumInputs      = 6;
sizes.DirFeedthrough = 0;
sizes.NumSampleTimes = 1;   % at least one sample time is needed

sys = simsizes(sizes);

%
% initialize the initial conditions
%
x0  = [...
    P.pn0;...
    P.pe0;...
    P.pd0;...
    P.u0;...
    P.v0;...
    P.w0;...
    P.phi0;...
    P.theta0;...
    P.psi0;...
    P.p0;...
    P.q0;...
    P.r0;...
    ];

%
% str is always an empty matrix
%
str = [];

%
% initialize the array of sample times
%
ts  = [0 0];

% Specify the block simStateCompliance. The allowed values are:
%    'UnknownSimState', < The default setting; warn and assume DefaultSimState
%    'DefaultSimState', < Same sim state as a built-in block
%    'HasNoSimState',   < No sim state
%    'DisallowSimState' < Error out when saving or restoring the model sim state
simStateCompliance = 'UnknownSimState';

% end mdlInitializeSizes

%
%=============================================================================
% mdlDerivatives
% Return the derivatives for the continuous states.
%=============================================================================
%
function sys=mdlDerivatives(t,x,uu, P)

    pn    = x(1);
    pe    = x(2);
    pe    = x(3);
    u     = x(4);
    v     = x(5);
    w     = x(6);
    phi   = x(7);
    theta = x(8);
    psi   = x(9);
    p     = x(10);
    q     = x(11);
    r     = x(12);
    fx    = uu(1);
    fy    = uu(2);
    fz    = uu(3);
    ell   = uu(4);
    m     = uu(5);
    n     = uu(6);
    %{
    Jx = 0.8244;
    Jy = 1.135;
    Jz = 1.759;
    Jxz = 0.1204;
    
    mass = 13.5;
    
    G = Jx*Jz - Jxz*Jxz;
    G1 = Jxz*(Jx - Jy + Jz) / G;
    G2 = (Jz*(Jz - Jy) + Jxz*Jxz) / G;
    G3 = Jz / G;
    G4 = Jxz / G;
    G5 = (Jz - Jx) / Jy;
    G6 = Jxz / Jy;
    G7 = ((Jx - Jy)*Jx + Jxz*Jxz) / G;
    G8 = Jx / G;
    
    pndot = (cos(theta)*cos(psi))* u + (sin(phi)*sin(theta)*cos(psi)-cos(phi)*sin(psi))*v + (cos(phi)*sin(theta)*cos(psi)+sin(phi)*sin(psi))*w; 
    pedot = (cos(theta)*sin(psi))* u + (sin(phi)*sin(theta)*sin(psi)+cos(phi)*cos(psi))*v + (cos(phi)*sin(theta)*sin(psi)-sin(phi)*cos(psi))*w;
    pddot = -sin(theta) * u + sin(phi)*cos(theta)*v + cos(phi)*cos(theta)*w;
    udot = r*v - q*w + fx/mass;
    vdot = p*w - r*u + fy/mass;
    wdot = q*u - p*v + fz/mass;
    phidot = 1*p + sin(phi)*tan(theta)*q + cos(phi)*tan(theta)*r;
    thetadot = 0*p + cos(phi)*q -sin(phi)*r;
    psidot = 0*p + (sin(phi)/cos(phi))*q +(cos(phi)/cos(theta))*r;
    pdot = G1*p*q - G2*q*r + G3*ell + G4*n;
    qdot = G5*p*r - G6*(p^2 - r^2) + m/Jy;
    rdot = G7*p*q - G1*q*r + G4*ell + G8*n;
    %}
    
    mass= P.mass;
    Jx = P.Jx;
    Jy = P.Jy;
    Jz = P.Jz;
    Jxz = P.Jxz;
    
    G=Jx*Jz-Jxz^2;
    G1 = Jxz*(Jx-Jy+Jz)/G;
    G2 = (Jz*(Jz-Jy)+Jxz^2)/G;
    G3 = Jz/G;
    G4 = Jxz/G;
    G5 = (Jz-Jx)/Jy;
    G6 = Jxz/ Jy;
    G7 = ((Jx-Jy)*Jx+Jxz^2)/G;
    G8 = Jx/G;

    pndot = [cos(theta)*cos(psi) sin(phi)*sin(theta)*cos(psi)-cos(phi)*sin(psi) cos(phi)*sin(theta)*cos(psi)+sin(phi)*sin(psi)]*[u, v, w]';
    pedot = [cos(theta)*sin(psi) sin(phi)*sin(theta)*sin(psi)+cos(phi)*cos(psi) cos(phi)*sin(theta)*sin(psi)-sin(phi)*cos(psi)]*[u, v, w]';
    pddot = [-sin(theta) sin(phi)*cos(theta) cos(phi)*cos(theta)]*[u, v, w]';
    udot = r*v - q*w +1/mass*fx;
    vdot = p*w-r*u + 1/mass*fy;
    wdot = q*u-p*v + 1/mass*fz;
    phidot = [1 sin(phi)*tan(theta) cos(phi)*tan(theta)]*[p, q, r]';
    thetadot = [0 cos(phi) -sin(phi)]*[p, q, r]';
    psidot = [0 sin(phi)/cos(theta) cos(phi)/cos(theta)]*[p, q, r]';
    pdot = G1*p*q - G2*q*r + G3*ell+G4*n; 
    qdot = G5*p*r - G6*(p^2-r^2) + 1/Jy*m;
    rdot = G7*p*q - G1*q*r + G4*ell + G8*n;

sys = [pndot; pedot; pddot; udot; vdot; wdot; phidot; thetadot; psidot; pdot; qdot; rdot];

% end mdlDerivatives

%
%=============================================================================
% mdlUpdate
% Handle discrete state updates, sample time hits, and major time step
% requirements.
%=============================================================================
%
function sys=mdlUpdate(t,x,u)

sys = [];

% end mdlUpdate

%
%=============================================================================
% mdlOutputs
% Return the block outputs.
%=============================================================================
%
function sys=mdlOutputs(t,x,u)

sys = x;

% end mdlOutputs

%
%=============================================================================
% mdlGetTimeOfNextVarHit
% Return the time of the next hit for this block.  Note that the result is
% absolute time.  Note that this function is only used when you specify a
% variable discrete-time sample time [-2 0] in the sample time array in
% mdlInitializeSizes.
%=============================================================================
%
function sys=mdlGetTimeOfNextVarHit(t,x,u)

sampleTime = 1;    %  Example, set the next hit to be one second later.
sys = t + sampleTime;

% end mdlGetTimeOfNextVarHit

%
%=============================================================================
% mdlTerminate
% Perform any end of simulation tasks.
%=============================================================================
%
function sys=mdlTerminate(t,x,u)

sys = [];

% end mdlTerminate
