package unification;
import function.*;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map.Entry;
import java.util.Set;

//import nabors.ruleA;

public class Unification {
	
	HashMap<String, HashSet<Var>> uniMap;
	HashMap<int[], HashSet<String>> nabor;
	HashMap<String, Entry<int[], HashSet<String>>> nabors;
	int numberOfNabor = 1;	
	boolean subst = false;
	public Set<Entry<String, Entry<int[], HashSet<String>>>> setOfNabors = new LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>>();
	
	public void unify(String exp1, String exp2) {
		exp1 = exp1.replaceAll(" ", "");
		exp2 = exp2.replaceAll(" ", "");
		uniMap = new HashMap<String, HashSet<Var>>();
		Var v1 = Var.parse(exp1);
		Var v2 = Var.parse(exp2);
		if (unify(v1, v2)) {
			outputUnificationResult();			
		} else {
			System.out.println("Failed to unify expressions");
		}
	}
	
	public Set<Entry<int[], HashSet<String>>> unify2(String exp1, String exp2, int index1, int index2) {
//		System.out.println(subst);
		exp1 = exp1.replaceAll(" ", "");
		exp2 = exp2.replaceAll(" ", "");
		uniMap = new HashMap<String, HashSet<Var>>();
		nabor = new HashMap<int[], HashSet<String>>();
		//newEntry = new HashMap<String, Set<Entry<int[], HashSet<String>>>>();
		nabors = new HashMap<String, Entry<int[], HashSet<String>>>();
		Set<Entry<int[], HashSet<String>>> set = nabor.entrySet();	
		Var v1 = Var.parse(exp1);
		Var v2 = Var.parse(exp2);
		//System.out.println(nabors.isEmpty() + " " + numberOfNabor);
		if (unify(v1, v2)) {
			set  = outputUnificationResultSet(exp1, exp2, index1, index2);			
		} else {
			System.out.println("Failed to unify expressions");
		}
		return set;
	}	
						
	public void printSet(Set<Entry<int[], HashSet<String>>> set) {
		for (Entry<int[], HashSet<String>> e : set) {					
			printEntry(e);															
		}		
	}	
	
	public void printEntry(Entry<int[], HashSet<String>> e) {
			// print of elems of nabor
			int[] elems = e.getKey();									
			//System.out.println();
			System.out.print("{");										
			for (int ros=0; ros<elems.length; ros++) {					
				if (ros==0) {						 	  				
					System.out.print(elems[ros]);							
				} else {												
					System.out.print(", " + elems[ros]);					
				}														
				//		if (ros==elems.length-1) {						 		
				//			System.out.print(" | ");							
			    //			}														
					}	
					System.out.print(" | ");														
			// print of svjazka of nabor
			String[] setArray = e.getValue().toArray(new String[e.getValue().size()]);
			for (int d=0; d<setArray.length; d++) {						
				if (d==setArray.length-1) {						 		
					System.out.print(setArray[d]);							
				} else {														
					System.out.print(setArray[d] + ", ");					
				}
			}	
			System.out.print("}");
		}
	
	
	public void addNabors(Set<Entry<int[], HashSet<String>>> set) { 
		for (Entry<int[], HashSet<String>> e : set) {
			nabors.put(Integer.toString(numberOfNabor), e);
			numberOfNabor++;
			Set<Entry<String, Entry<int[], HashSet<String>>>> setN = nabors.entrySet();			
			for (Entry<String, Entry<int[], HashSet<String>>> s : setN) {					
				if (s.getKey() != null || s.getValue() != null) {
					setOfNabors.add(s);					
				}
			}			
		}
	}
	
	public void printNabors() {
		//Set<Entry<String, Entry<int[], HashSet<String>>>> setN = nabors.entrySet();
		
		//for (Entry<String, Entry<int[], HashSet<String>>> e : setN) {					
		for (Entry<String, Entry<int[], HashSet<String>>> e : setOfNabors) {					
			// print of number of nabor
			System.out.print("\n" + e.getKey() + ". ");				 					
			// print of nabor
			printEntry(e.getValue());
		}
	}	
	
	
	public void printNaborsA() { // print nabors with analysis "A"
		//Set<Entry<String, Entry<int[], HashSet<String>>>> setN = nabors.entrySet();
		
		//for (Entry<String, Entry<int[], HashSet<String>>> e : setN) {					
		for (Entry<String, Entry<int[], HashSet<String>>> e : setOfNabors) {					
			// print of number of nabor
			System.out.print("\n" + e.getKey() + ". ");				 					
			// print of nabor
			printEntry(e.getValue());
			// print analysis "A"
			System.out.print(" Rule A");	
		}
	}	
		
	private boolean unify(Var v1, Var v2) {
//		System.out.println("Unify: " + v1.name + " and " + v2.name);
		if (v1 instanceof Literal && v2 instanceof Literal) {
			// both literals
			if (v1.name.equals(v2.name)) {
				// same literal unifies to itself
				return true;
			} else {
				return addUnificationRule((Literal) v1, v2) && addUnificationRule((Literal) v2, v1);
			}
		} else if (v1 instanceof Literal && v2 instanceof Function) {
			return !isSelfReferential((Literal) v1, (Function) v2) && addUnificationRule((Literal) v1, v2);
		} else if (v1 instanceof Function && v2 instanceof Literal) {
			return !isSelfReferential((Literal) v2, (Function) v1) && addUnificationRule((Literal) v2, v1);
		} else {
			// both are functions
			Function f1 = (Function) v1;
			Function f2 = (Function) v2;
			if (f1.name.equals(f2.name) && f1.getArity() == f2.getArity()) {
				// unify parameters
				for (int i = 0; i < f1.getArity(); i++) {
					if (!unify(f1.getParameter(i), f2.getParameter(i))) {
						return false;
					}
				}
				return true;
			} else {
				return false;
			}
		}
	}
	
	public boolean addUnificationRule(Literal l, Var v) {
		if(uniMap.containsKey(l.name)) {
			HashSet<Var> set = uniMap.get(l.name);
			if (set.contains(v)) {
				return true;
			} else {
				set.add(v);
				for (Var nv : set) {
					if(!unify(v, nv)) {
						return false;
					}
				}
				return true;
			}
		} else {
			HashSet<Var> set = new HashSet<Var>();
			set.add(v);
			uniMap.put(l.name, set);
			return true;
		}
	}
		
	private boolean isSelfReferential(Literal l, Function f) {
		for (int i = 0; i < f.getArity(); i++) {
			if (f.getParameter(i) instanceof Literal) {
				if (l.equals(f.getParameter(i))) {
					return true;
				}
			} else {
				if (isSelfReferential(l, (Function)f.getParameter(i))) {
					return true;
				}
			}
		}
		return false;
	}
	
	private void outputUnificationResult() {
		Set<Entry<String, HashSet<Var>>> entrySet = uniMap.entrySet();
		for (Entry<String, HashSet<Var>> e : entrySet) {
			System.out.println("Variable " + e.getKey() + " unifies to:");
			for (Var v : e.getValue()) {
				//System.out.println("\t" + v.toString());
				System.out.println("\t" + v.toString() + "=" + e.getKey());
			}
		}
	}
	
	private Set<Entry<int[], HashSet<String>>> outputUnificationResultSet(String exp1, String exp2, int index1, int index2) {
		
		Set<Entry<String, HashSet<Var>>> entrySet = uniMap.entrySet();		
		
			// check for every var that var don't equals to 2 const in one time  
			boolean binarySet = false;  
			for (Entry<String, HashSet<Var>> e : entrySet) {
				if (e.getValue().size() > 1) {
					binarySet = true;
				}
			}
			
			if (binarySet == false) { //every var equals only to 1 const in one time
				
				HashSet<String> set = new HashSet<String>();

				for (Entry<String, HashSet<Var>> e : entrySet) {

					if (Character.getNumericValue(e.getKey().charAt(0)) > 24) { // key begininnig with variabalic letter, i.e. it is variable, 24 is number of 'o'
						
						String eq = e.toString();
//						eq = eq.replaceAll("[", "");
//						eq = eq.replaceAll("]", "");

						if (index1 == index2) {	
							if (!exp1.contains("^") || !exp2.contains("^")) {
								eq = eq.replaceAll(e.getKey(), e.getKey() + "^" + 1);	
							}
						} else {// ! index1 == index2
							if (!exp1.contains("^") && exp1.contains(e.getKey())) {
								eq = eq.replaceAll(e.getKey(), e.getKey() + "^" + 1);
							}
							if (!exp2.contains("^") && exp2.contains(e.getKey())) {
								eq = eq.replaceAll(e.getKey(), e.getKey() + "^" + 2);
							}
						}
						set.add(eq);	
					} 					
				}
				
//				System.out.println("exp1 is: " + exp1);
//				System.out.println("exp2 is: " + exp2);
				
				if (index1 == index2) {						
					if (subst == false) {		// add 1-elems nabor	
						int[] elems = {index1};
//						System.out.println("elems: " + elems.length + " substit: " + subst);
						nabor.put(elems, set);
					} else { 					// add 2-elems nabor	
						int[] elems = {index1, index2};
//						System.out.println("elems: " + elems.length + " substit: " + subst);
						nabor.put(elems, set);
					}
				} else { // ! index1 == index2
					int[] elems = {index1, index2};
//					System.out.println("elems: " + elems.length + " substit: " + subst);
					nabor.put(elems, set);					
				}
			
			} else { //exist at least one var that equals to 2 const in one time, i.e. binarySet == true, i.e. e.getValue().size() > 1
			    // divide HashSet<Var> if it contains more than 1 elem
				
				String exp11 = "";
				String exp12 = "";
				String exp21 = "";
				String exp22 = "";
				
//				System.out.println("exp1 is: " + exp1);
//				System.out.println("exp2 is: " + exp2);
				
				for (Entry<String, HashSet<Var>> e : entrySet) {
//					System.out.println(Character.getNumericValue(e.getKey().charAt(0)) + " " + e.getKey());
					if (Character.getNumericValue(e.getKey().charAt(0)) > 24) { // key begininnig with variabalic letter, i.e. it is variable, 24 is number of 'o'
						
						exp11 = exp1.replace(e.getKey(), e.getKey() + "^" + 1); // subst
						exp12 = exp2.replace(e.getKey(), e.getKey() + "^" + 2); // subst
						exp21 = exp1.replace(e.getKey(), e.getKey() + "^" + 2); // subst
						exp22 = exp2.replace(e.getKey(), e.getKey() + "^" + 1); // subst
						e.getValue().clear();
						subst = true;
						
					} 
					
				}
//				System.out.println("exp1 is: " + exp1);
//				System.out.println("exp2 is: " + exp2);
//				System.out.println(subst);
				Unification unif = new Unification();
				unif.subst = true;
				Set<Entry<int[], HashSet<String>>> set1 = unif.unify2(exp11, exp12, index1, index2);
				//unif.printSet(set1);
				addNabors(set1);
				//System.out.println(" ");
				Set<Entry<int[], HashSet<String>>> set2 = unif.unify2(exp21, exp22, index1, index2);
				//unif.printSet(set2);
				addNabors(set2);

			}				
		
		Set<Entry<int[], HashSet<String>>> result = nabor.entrySet();
			
		return result;
	}	
	
	
	public void initialNabors(String[][] s) {	// create initial nabors	

		String begin = "";
		String end = "";
		
		for(int i=0; i<s.length; i++) {
			for(int j=0; j<s[i].length; j++) {
				
				for(int i1=i; i1<s.length; i1++) {
					int r;
					if (i1 == i) {
						r = j;
					} else {
						r = 0;
					}
					for (int j1=r; j1<s[i1].length; j1++) {
					//System.out.println(i + " " + j + " " + i1 + " " + j1 + "\n");
					//System.out.println(s[i][j] + " " + s[i1][j1] + "\n");
						if (s[i][j].charAt(0) == '\u00AC') {
							if (s[i1][j1].charAt(0) != '\u00AC') {
								if (s[i][j].charAt(1) == s[i1][j1].charAt(0)) {
									// CONTRARY PAIR
									//System.out.println("\n" + "Contrary pair is: " + s[i][j] + " " + s[i1][j1] + "\n"); 
									begin = s[i][j].substring(1);
									end = s[i1][j1];
									
								}
							}
						} else {
							if (s[i1][j1].charAt(0) == '\u00AC') {
								if (s[i][j].charAt(0) == s[i1][j1].charAt(1)) {
									// CONTRARY PAIR
									//System.out.println("\n" + "Contrary pair is: " + s[i][j] + " " + s[i1][j1] + "\n");  
									begin = s[i][j];
									end = s[i1][j1].substring(1);									
								}
							}
						}
						if (begin != "" && end != "") {
							Set<Entry<int[], HashSet<String>>> set = unify2(begin, end, i+1, i1+1);
							//printSet(set);
							//System.out.println();
							addNabors(set);
							begin = "";
							end = "";
						}
					}
				}
			
			}
		}
		
		//System.out.println("\n" + "Initial nabors are:");
		//printNaborsA();
	}
	
	
	public void printRazbivka(String[][] razbivka) {
		System.out.println("Razbivka of this formula is:");
		// in column:
		//for(int i=0; i<razbivka.length; i++) {
		//	for(int j=0; j<razbivka[i].length; j++) {
		//		System.out.println(i + " " + j + " is : " + razbivka[i][j]);
		//	}
		//}
		// in row:
		for(int i=0; i<razbivka.length; i++) {
			for(int j=0; j<razbivka[i].length; j++) {
				if (i==0 && j==0) {
					System.out.print(razbivka[i][j]);					
				} else {
					if (j == 0) {
						System.out.print(", " + razbivka[i][j]);
					} else {
						System.out.print('\u2228' +  " " + razbivka[i][j]);	
					}
				}
			}
		}		
		System.out.println();
	}
	
	
}