package nabors;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
//import java.lang.Object.*;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map.Entry;
//import java.util.Arrays;







import java.util.Set;

import unification.Unification;

public class MainStr {
	
	//SortedMap sortedMap = new TreeMap();
	
	public Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> mainSet = new LinkedHashSet<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>>();
	public Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> mainUpSet = new LinkedHashSet<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>>();
	
	
	SortedMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> sortedSet;
	SortedMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> sortedUpSet;
	
	ConcurrentHashMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> mainS;
	ConcurrentHashMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> mainUpS;
	
	LinkedHashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> mainStr;
	LinkedHashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> mainUpStr;
	LinkedHashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> specUpStr;
	
	HashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> factSetOfNabors;
	HashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> factUpSetOfNabors;
	
	HashMap<String, Entry<String, Entry<int[], HashSet<String>>>> numberedToDelElemOfNabors;
	HashMap<String, Entry<String, Entry<int[], HashSet<String>>>> numberedUpToDelElemOfNabors;
	
	Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> SetOfNumberedToDelElemOfNabors = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
	Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> SetUpOfNumberedToDelElemOfNabors = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
	
	
	//IN: set of nabors Num --> Nabor
	//OUT: set of nabors with index what component to deletion: NumToDel --> Num --> Nabor
	
	public Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> createGSoN(Set<Entry<String, Entry<int[], HashSet<String>>>> set) {	// create general SetOfNabors (GSoN)
		numberedToDelElemOfNabors = new HashMap<String, Entry<String, Entry<int[], HashSet<String>>>>();
		
		for (Entry<String, Entry<int[], HashSet<String>>> e : set) {					
			for (int i=0; i < e.getValue().getKey().length; i++) {
				numberedToDelElemOfNabors.put(Integer.toString(i+1), e); // i+1 --   
				Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> entrySet = numberedToDelElemOfNabors.entrySet();	
				addNumNab(entrySet);
				numberedToDelElemOfNabors.clear();
			}
		}
		System.out.print("\n");
		//printSetNab(SetOfNumberedToDelElemOfNabors);
		return SetOfNumberedToDelElemOfNabors;
	}
		
	//IN: set of nabors Num --> Nabor
	//OUT: factorized set of nabors with index what component to deletion: ElemOfRazbivka --> NumToDel --> Num --> Nabor	
	
	public void createFSoN(Set<Entry<String, Entry<int[], HashSet<String>>>> set, int length) {	// create factSetOfNabors (FSoN)
		
		factSetOfNabors = new HashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();
		
		Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> setG = createGSoN(set); // create general 
		
		for (int i = 1; i <length+1; i++) {
			Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> setNew = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
			for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e : setG) {
				Entry<String, Entry<int[], HashSet<String>>> nab = e.getValue();
				//System.out.print("\n" + "i is: " + i + ",  " + e.getKey() + " is: " + Integer.parseInt(e.getKey(), 10));
				if (i == nab.getValue().getKey()[Integer.parseInt(e.getKey(), 10)-1]) {
					setNew.add(e);
				} 
			}
			factSetOfNabors.put(Integer.toString(i), setNew);
		}		
	}
	
	// create main structure (MS)	
	// length -- quantity of elements of razbivka (DELTA)
	// quantity -- quantity of parameters of initial formula
	
	public void createMS(Set<Entry<String, Entry<int[], HashSet<String>>>> set, int length, int quantity) {	
		
		mainStr = new LinkedHashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();
		
		createFSoN(set, length);
		//System.out.println("/**************************************: ");
		//System.out.println("factSetOfNabors is: ");
		//printFSoN(); 	
		//System.out.println("/**************************************: ");
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> factSet = factSetOfNabors.entrySet();	
		
		int gsize = 1;
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : factSet) {
			gsize = gsize*e.getValue().size();
		}
		if (gsize > 0) {
		
			//System.out.print("gsize is: " + gsize + ". ");
			// create many-many sets kind of Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>
			for (int i=0; i<gsize; i++) {
				Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> mainSubSet = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
				mainStr.put(Integer.toString(i), mainSubSet);
			}
			// fill of many-many sets
			int cnt = gsize;
			int quant = 0;
			int begin = 0;
			for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : factSet) {
				cnt = cnt/e.getValue().size();
				quant = gsize/(cnt*e.getValue().size());
				//System.out.println("cnt is: " + cnt + ". " + "begin is: " + begin + ". " + "quant is: " + quant + ". ");
				//System.out.println("BEGIN!");
				for (int q = 0; q < quant; q++) {
					for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e1 : e.getValue()) {
						for (int num = begin; num < begin + cnt; num++) {
							Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> subSet = mainStr.get(Integer.toString(num));
							subSet.add(e1);
						}
						begin = begin + cnt;
						//System.out.println("cnt is: " + cnt + ". " + "begin is: " + begin + ". ");
					}				
				}
				begin = 0;
			}
		}
		//Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> mS = mainStr.entrySet();	
		//printMS();
		createOrderedMS(length, quantity);
	}	

	public Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> createUpGSoN(Set<Entry<String, Entry<int[], HashSet<String>>>> set) {	// create general SetOfNabors (GSoN)
		
		numberedUpToDelElemOfNabors = new HashMap<String, Entry<String, Entry<int[], HashSet<String>>>>();
		numberedUpToDelElemOfNabors.clear();
		SetUpOfNumberedToDelElemOfNabors.clear();
		
		for (Entry<String, Entry<int[], HashSet<String>>> e : set) {					
			for (int i=0; i < e.getValue().getKey().length; i++) {
				numberedUpToDelElemOfNabors.put(Integer.toString(i+1), e); // i+1 --   
				Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> entrySet = numberedUpToDelElemOfNabors.entrySet();	
				addUpNumNab(entrySet);
				numberedUpToDelElemOfNabors.clear();
			}
		}
		System.out.print("\n");
		//printSetNab(SetUpOfNumberedToDelElemOfNabors);
		return SetUpOfNumberedToDelElemOfNabors;
	}
	
	public void createUpFSoN(Set<Entry<String, Entry<int[], HashSet<String>>>> set, int length) {	// create factSetOfNabors (FSoN)
				
		boolean ch = true;
	 	int len1 = 0;
		int len2 = 0;
		factUpSetOfNabors = new HashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySetFact = factSetOfNabors.entrySet();
				
		Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> setG = createUpGSoN(set); // create general 
		
		for (int i = 1; i <length+1; i++) {
			Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> setNew = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
			for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e : setG) {
				Entry<String, Entry<int[], HashSet<String>>> nab = e.getValue();
				//System.out.print("\n" + "i is: " + i + ",  " + e.getKey() + " is: " + Integer.parseInt(e.getKey(), 10));
				if (i == nab.getValue().getKey()[Integer.parseInt(e.getKey(), 10)-1]) {
					setNew.add(e);
				} 
			}
		
			Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> setMinus = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
			
			// don't add those element that are already in FactSet, don't copy entities
			for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> eD: setNew) {
				for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> eF: entrySetFact) {
					for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> eFin:  eF.getValue()) {
						if (eD.getKey().equals(eFin.getKey())) {
							len1 = eD.getValue().getValue().getKey().length;
							len2 = eFin.getValue().getValue().getKey().length;
							if (len1 == len2) {
								ch = true;
								for (int k = 0; k < len1; k++) {
									if (eD.getValue().getValue().getKey()[k] != eFin.getValue().getValue().getKey()[k]) {
										ch = false;
										break;
									}
								}
								if (ch == true) {
									if (isEqual(eD.getValue().getValue().getValue(), eFin.getValue().getValue().getValue())) {
										setMinus.add(eD);
									}
								}
							}
						} 
					}
				}
			}
			setNew.removeAll(setMinus);
		
			factUpSetOfNabors.put(Integer.toString(i), setNew);
		}
		
	}

public boolean isEqual(HashSet<String> set1, HashSet<String> set2) {
		
		boolean result;
		
		Set<String> difference1 = new HashSet<String>(set1);
		difference1.removeAll(set2);
		Set<String> difference2 = new HashSet<String>(set2);
		difference2.removeAll(set1);
		if (difference1.isEmpty() && difference2.isEmpty()) {
			result = true;
		} else {
			result = false;
		}
		return result;
	}

	public void updatefactSetOfNabors() {
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = factUpSetOfNabors.entrySet();
		
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> factSet = factSetOfNabors.get(e.getKey());
			
			Iterator<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> itr = e.getValue().iterator();
			while (itr.hasNext()) {
				factSet.add(itr.next());
			}
			factSetOfNabors.put(e.getKey(), factSet);
		}		
	}
	
	public void createUpMS(Set<Entry<String, Entry<int[], HashSet<String>>>> set, int length, int quantity) {	
		
		mainUpStr = new LinkedHashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();
		specUpStr = new LinkedHashMap<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();
		
		mainUpStr.clear();
		//System.out.println("mainUpStr.size: " + mainUpStr.size());
		

		createUpFSoN(set, length);
		//System.out.println("/**************************************: ");
		//System.out.println("factUpSetOfNabors is: ");
		//printUpFSoN();
		//System.out.println("/**************************************: ");
		
		String[] oldnew = new String[(int) Math.pow((double) 2, (double) length)];
		for (int i = 0; i <oldnew.length; i++) {
			oldnew[i] = Integer.toBinaryString(i);
			while (oldnew[i].length() < length) {
				oldnew[i] = Integer.toString(0) + oldnew[i];
			}
			//System.out.println("i is: " + oldnew[i] + ". ");
		}
		for (int i = 0; i <oldnew.length; i++) {
			String s = oldnew[i];
			//System.out.println("\n" + "s is: " + s + " s contain 1: " + s.contains(Integer.toString(1)) + ". ");
			if (s.contains(Integer.toString(1))) {
				specUpStr.clear();
				for (int j=0; j < s.length(); j++) {
					 if (s.substring(j, j+1).equals(Integer.toString(0))) { 	// get from oldSet
						 Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> callSet = factSetOfNabors.get(Integer.toString(j+1));
						 specUpStr.put(Integer.toString(j+1), callSet);						 
					 } else {											//  get from newSet
						 Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> callSet = factUpSetOfNabors.get(Integer.toString(j+1));
						 specUpStr.put(Integer.toString(j+1), callSet);	
					 }
				}
				Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> call = specUpStr.entrySet();
				//System.out.println("/**************************************: ");
				//System.out.println("new Nabors of Nabors is: ");
				//printSpecUpStr();
				//System.out.println("/**************************************: ");		
				createNewRowInMainStr(call);
				specUpStr.clear();
			}
		}
		
		updatefactSetOfNabors();		
		factUpSetOfNabors.clear();		
		//Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> mS = mainStr.entrySet();	
		//System.out.println("BEGIN OLD!");
		//printMS();
		//System.out.println("BEGIN NEW!");
		//printUpMS();
		//createOrderedMS(length, quantity);
	}		
	
	public void createNewRowInMainStr(Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> set) {
		
		int index = mainUpStr.size();
		int gsize = 1;
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : set) {
			gsize = gsize*e.getValue().size();
		}
	//	System.out.print("gsize is: " + gsize + ". ");
		
		if (gsize > 0) {
			// create many-many sets kind of Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>
			
			for (int i=index; i<index+gsize; i++) {
				Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> mainSubSet = new HashSet<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>();
				mainUpStr.put(Integer.toString(i), mainSubSet);
			}
			// fill of many-many sets
			int cnt = gsize;
			int quant = 1;
			int begin = 0;
			for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : set) {
				cnt = cnt/e.getValue().size();
				quant = gsize/(cnt*e.getValue().size());
				//System.out.println("cnt is: " + cnt + ". " + "begin is: " + begin + ". " + "quant is: " + quant + ". ");
				//System.out.println("BEGIN!");
				for (int q = 0; q < quant; q++) {
					for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e1 : e.getValue()) {
						for (int num = begin; num < begin + cnt; num++) {
							Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> subSet = mainUpStr.get(Integer.toString(num + index)); //// + index???
							subSet.add(e1);
						}
						begin = begin + cnt;
						//System.out.println("cnt is: " + cnt + ". " + "begin is: " + begin + ". ");
					}				
				}
				begin = 0;
			}
		}
	}
	
	public void incrIndex(Double index) {		
		sortedSet.put(index+1.0, sortedSet.get(index)); // change index of used nNabors	
		sortedSet.remove(index); // delete this pair
	}
	
	public void delElem(Double index) {		
		sortedSet.remove(index); // delete this pair
		mainSet.clear();
		addNabors();
	}
	
	public void updateMS(Entry<String, Entry<int[], HashSet<String>>> newNabor, int length, int quantity) {	
		
		Set<Entry<String, Entry<int[], HashSet<String>>>> set = new HashSet<Entry<String, Entry<int[], HashSet<String>>>>();
		set.add(newNabor);
		
		createUpMS(set, length, quantity);		
		createOrderedUpMS(length, quantity);
		addNaborNewToOld();
		//printMainSet(mainSet);
	}
	
	public void createOrderedMS(int length, int quantity) {

		mainS = new ConcurrentHashMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();
		
		//Map map = new HashMap();	
		//SortedMap sortedMap = new TreeMap(map);
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> mS = mainStr.entrySet();	
		int corr = mainS.size();
		
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : mS) {
			double index = 0;
			double lengthOfNab = 0;
			double lengthOfSviaz = 0;
			double coefOfNab = 0;
			double coefOfSviaz = 0;
			double genN = 0;
			double genS = 0;
			double genCoefN = 0;
			double genCoefS = 0;
			int n = e.getValue().size();
			Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> nabor = e.getValue();
			Set<String> setOfPn = new HashSet<String>();
			Set<Integer> setOfNum = new HashSet<Integer>();
			int minus = 0; 									// correction for nabors which will we delited in appling ruleB
			for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e1 : nabor) {					
				
				genN = genN + e1.getValue().getValue().getKey().length;				
				genS = genS + e1.getValue().getValue().getValue().size();
				
				for (int i = 0; i < e1.getValue().getValue().getKey().length; i++) {
					setOfNum.add(e1.getValue().getValue().getKey()[i]);					
				}
				
				genCoefN = genCoefN + setOfNum.size();	
				
				// how many elements of sviazka will be deleted when we apply B-rule to this nabor of nabors? 
				// this number is minus
				for (int i = 0; i < e1.getValue().getValue().getValue().size(); i++) {
					Iterator<String> itr = e1.getValue().getValue().getValue().iterator();
					while (itr.hasNext()) {
						String str = itr.next();
						String substr1 = str.substring(0, str.indexOf("="));
						int nom = Integer.parseInt(substr1.substring(substr1.indexOf("^")+1), 10); // number of elem razbivki
						int nom1 = e1.getValue().getValue().getKey()[nom-1];
						String strWithSubst = substr1.substring(0, substr1.indexOf("^")) + Integer.toString(nom1);
						//System.out.println("substr1 is: " + substr1 + " strWithSubst: " + strWithSubst);	
						//String substr2 = str.substring(str.indexOf("=")+1);
						//System.out.println("substr1 is: " + substr1 + " substr2 is: " + substr2);
						setOfPn.add(strWithSubst);
						if (e1.getKey().equals(substr1.substring(substr1.indexOf("^")+1))) {
							minus++;
						}
					}
					
				}
				genCoefS = setOfPn.size();				
				//System.out.println("minus is: " + minus);	
				//System.out.println("setOfPn.size() is: " + setOfPn.size());	
				//System.out.println("genCoefS is: " + genCoefS);
				//setOfPn.clear();
			}
			genS = genS - minus;
			// COEFFICIETS OF INDEX:
			lengthOfNab = genN/n;
			lengthOfSviaz = genS/n;
			if (lengthOfSviaz == 0.0) {
				lengthOfSviaz = 0.01;
			}
			coefOfNab = 1/(genCoefN/(n*length));
			coefOfSviaz = genCoefS/(n*quantity);
			index = lengthOfNab*coefOfNab + lengthOfSviaz*coefOfSviaz;
			index = index + (corr*0.0000000001);
			//System.out.println("lengthOfNab is: " + lengthOfNab + ". " + "lengthOfSviaz is: " + lengthOfSviaz + ". " + "coefOfNab is: " + coefOfNab + ". " + "coefOfSviaz is: " + coefOfSviaz + ". ");
			//System.out.println("lengthOfNab*coefOfNab is: " + lengthOfNab*coefOfNab + ". " + "lengthOfSviaz*coefOfSviaz is: " + lengthOfSviaz*coefOfSviaz + ". ");
			//System.out.println("lengthOfNab*coefOfNab + lengthOfSviaz*coefOfSviaz is: " + (lengthOfNab*coefOfNab + lengthOfSviaz*coefOfSviaz) + ". ");
			//System.out.println("\n");
			//System.out.println("index is: " + index + ". ");
			//System.out.println("\n");
			corr++;
			
			mainS.put(index, e.getValue());		
		}		
		sortedSet = new TreeMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>(mainS);
		addNabors();		
		//printOrderedMS();
	}
	
	
	public void createOrderedUpMS(int length, int quantity) {

		mainUpS = new ConcurrentHashMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>();
		
		//Map map = new HashMap();	
		//SortedMap sortedMap = new TreeMap(map);
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> mS = mainUpStr.entrySet();	
		int corr =  mainS.size();
		
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : mS) {
			double index = 0;
			double lengthOfNab = 0;
			double lengthOfSviaz = 0;
			double coefOfNab = 0;
			double coefOfSviaz = 0;
			double genN = 0;
			double genS = 0;
			double genCoefN = 0;
			double genCoefS = 0;
			int n = e.getValue().size();
			Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> nabor = e.getValue();
			Set<String> setOfPn = new HashSet<String>();
			Set<Integer> setOfNum = new HashSet<Integer>();
			int minus = 0; 									// correction for nabors which will we delited in appling ruleB
			for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e1 : nabor) {					
				
				genN = genN + e1.getValue().getValue().getKey().length;				
				genS = genS + e1.getValue().getValue().getValue().size();
				
				for (int i = 0; i < e1.getValue().getValue().getKey().length; i++) {
					setOfNum.add(e1.getValue().getValue().getKey()[i]);					
				}
				
				genCoefN = genCoefN + setOfNum.size();	
				
				// how many elements of sviazka will be deleted when we apply B-rule to this nabor of nabors? 
				// this number is minus
				for (int i = 0; i < e1.getValue().getValue().getValue().size(); i++) {
					Iterator<String> itr = e1.getValue().getValue().getValue().iterator();
					while (itr.hasNext()) {
						String str = itr.next();
						String substr1 = str.substring(0, str.indexOf("="));
						int nom = Integer.parseInt(substr1.substring(substr1.indexOf("^")+1), 10); // number of elem razbivki
						int nom1 = e1.getValue().getValue().getKey()[nom-1];
						String strWithSubst = substr1.substring(0, substr1.indexOf("^")) + Integer.toString(nom1);
						//System.out.println("substr1 is: " + substr1 + " strWithSubst: " + strWithSubst);	
						//String substr2 = str.substring(str.indexOf("=")+1);
						//System.out.println("substr1 is: " + substr1 + " substr2 is: " + substr2);
						setOfPn.add(strWithSubst);
						if (e1.getKey().equals(substr1.substring(substr1.indexOf("^")+1))) {
							minus++;
						}
					}
					
				}
				genCoefS = setOfPn.size();				
				//System.out.println("minus is: " + minus);	
				//System.out.println("setOfPn.size() is: " + setOfPn.size());	
				//System.out.println("genCoefS is: " + genCoefS);
				//setOfPn.clear();
			}
			genS = genS - minus;
			// COEFFICIETS OF INDEX:
			lengthOfNab = genN/n;
			lengthOfSviaz = genS/n;
			if (lengthOfSviaz == 0.0) {
				lengthOfSviaz = 0.01;
			}
			coefOfNab = 1/(genCoefN/(n*length));
			coefOfSviaz = genCoefS/(n*quantity);
			index = lengthOfNab*coefOfNab + lengthOfSviaz*coefOfSviaz;
			index = index + (corr*0.0000000001);
			//System.out.println("lengthOfNab is: " + lengthOfNab + ". " + "lengthOfSviaz is: " + lengthOfSviaz + ". " + "coefOfNab is: " + coefOfNab + ". " + "coefOfSviaz is: " + coefOfSviaz + ". ");
			//System.out.println("lengthOfNab*coefOfNab is: " + lengthOfNab*coefOfNab + ". " + "lengthOfSviaz*coefOfSviaz is: " + lengthOfSviaz*coefOfSviaz + ". ");
			//System.out.println("lengthOfNab*coefOfNab + lengthOfSviaz*coefOfSviaz is: " + (lengthOfNab*coefOfNab + lengthOfSviaz*coefOfSviaz) + ". ");
			//System.out.println("\n");
			//System.out.println("index is: " + index + ". ");
			//System.out.println("\n");
			corr++;
			
			mainUpS.put(index, e.getValue());		
		}		
		sortedUpSet = new TreeMap<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>(mainUpS);
		addUpNabors();		
		//printUpOrderedMS();
	}
		
	public void addNabors() { 
		
		Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> maSet = sortedSet.entrySet();
		
		for (Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : maSet) {
				mainSet.add(e);					
		}
	}
	
	public void addUpNabors() { 
		
		Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> maSet = sortedUpSet.entrySet();
		
		for (Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : maSet) {
				mainUpSet.add(e);					
		}
	}
	
	
	public void addNaborNewToOld() { 
		
		Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> maSet = sortedUpSet.entrySet();
		
		for (Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : maSet) {
			sortedSet.put(e.getKey(), e.getValue());
		}
		mainSet.clear();
		addNabors();
	}
	
	
	public void addNumNab(Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> set) { 
		for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e : set) {
			SetOfNumberedToDelElemOfNabors.add(e);			
		}
	}
	
	public void addUpNumNab(Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> set) { 
		for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e : set) {
			SetUpOfNumberedToDelElemOfNabors.add(e);			
		}
	}
	
	public void printSpecUpStr() {

		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = specUpStr.entrySet();
				
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
		}
	}
	
	public void printFSoN() {

		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = factSetOfNabors.entrySet();
				
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
		}
	}	
	
	public void printUpFSoN() {
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = factUpSetOfNabors.entrySet();
				
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
		}
	}	
	
	public void printMS() {
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = mainStr.entrySet();
				
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
		}
	}	
	
	public void printUpMS() {
		
		Set<Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = mainUpStr.entrySet();
				
		for (Entry<String, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
		}
	}	
	
	public void printOrderedMS() {
		
		Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = sortedSet.entrySet();
		
		int i = 1;	 
		for (Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			System.out.print("\n" + "Number: " + i);
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
			i++;
		}
	}	
	
	public void printMainSet(Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> set) {

		int i = 1;	 
		for (Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : set) {					
			System.out.print("\n" + "Number: " + i);
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
			i++;
		}
	}
	
	public void printUpOrderedMS() {

		Set<Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>>> entrySet = sortedUpSet.entrySet();
		
		int i = 1;	 
		for (Entry<Double, Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>> e : entrySet) {					
			System.out.print("\n" + "Number: " + i);
			// print of number of elem. razbibka
			System.out.print("\n" + e.getKey() + ". " + "\n");
			// print of nabor
			printSetNab(e.getValue());
			i++;
		}
	}
										
	public void printSetNab(Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> set) {				
		for (Entry<String, Entry<String, Entry<int[], HashSet<String>>>> e : set) {					
			// print of number of deleting number of nabor
			System.out.print(e.getKey() + ". ");
			// print of nabor
			printNab(e.getValue());
		}
	}	
	
	public void printNab(Entry<String, Entry<int[], HashSet<String>>> e) {				
		
		Unification uni = new Unification();							
			// print of number of nabor
			System.out.print(e.getKey() + ". ");				 					
			// print of nabor
			uni.printEntry(e.getValue());
			System.out.print("\n");
	}
	
	public Iterator<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> createIterator(Set<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>> entrySet) {	// create Iterator
		
		Iterator<Entry<String, Entry<String, Entry<int[], HashSet<String>>>>>  itr = entrySet.iterator();
		return itr;
	}
		
	
}
