package nabors;

import java.util.*;
import java.util.Map.Entry;

//import function.Literal;

//import unification.Unification;
//import function.Var;

public class Skleyka {
	
	LinkedHashMap<Integer, HashSet<String>> classEquiv;
	HashMap<String, Entry<int[], HashSet<String>>> naboren;
	HashMap<int[], HashSet<String>> naboro;
	
	
	public boolean isAppSkleyka(Entry<String, Entry<int[], HashSet<String>>> nabor) {		
		
		boolean result;
		
		Set<Integer> set = new HashSet<Integer>(); 
		for (int i = 0; i < nabor.getValue().getKey().length; i++) {
			set.add(nabor.getValue().getKey()[i]);
		}
		if (set.size() != nabor.getValue().getKey().length) {
			result = true;
		} else {
			result = false;
		}
		return result;
	}
	
	public LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> ruleSkleyka(Entry<String, Entry<int[], HashSet<String>>> nabor, String[] parameters, int nextnumber, LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> bag) {
		return  ruleSkleykaII(nabor, 0, 1, parameters, nextnumber, bag);			
	}
	
	public LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> ruleSkleykaII(Entry<String, Entry<int[], HashSet<String>>> nabor, int left, int right, String[] parameters, int nextnumber, LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> bag) { //left=right
		
		naboren = new HashMap<String, Entry<int[], HashSet<String>>>();
		naboro = new HashMap<int[], HashSet<String>>();
		
		LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> result = new LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>>(bag);
		
		for (int i = left; i < nabor.getValue().getKey().length; i++) {
			left++;
			for (int j = right; j < nabor.getValue().getKey().length; j++) {
				right++;
				if (nabor.getValue().getKey()[i] == nabor.getValue().getKey()[j]) {
					//System.out.print("\n" + "i is: " + i + " " + nabor.getValue().getKey()[i] + " " + "j is: " + j + " " + nabor.getValue().getKey()[j]);
					int[] elem = new int[]{i+1,j+1}; 
					HashSet<String> sviazkaNew = createNewSviazka(nabor.getValue().getValue(), elem, parameters);
					
					if (!isEqual(sviazkaNew, nabor.getValue().getValue())) { 			 // if different sviazka then do skleyka
						int[] newcomp = delElArray(nabor.getValue().getKey(), j);        //	if not then return the same nabor
						HashSet<String> sviazkaNewNew = subtractIndexes(sviazkaNew, j+1);
						naboro.put(newcomp, sviazkaNewNew);        						 // recursively do
						Set<Entry<int[], HashSet<String>>> nabs = naboro.entrySet();
						for (Entry<int[], HashSet<String>> e: nabs) {
							naboren.put(Integer.toString(nextnumber), e);
						}						
						Set<Entry<String, Entry<int[], HashSet<String>>>> nabswithn = naboren.entrySet();
						Iterator<Entry<String, Entry<int[], HashSet<String>>>> itr = nabswithn.iterator();																							
						//res.add(itr.next());		
						Entry<String, Entry<int[], HashSet<String>>> enter = itr.next();
						result.add(enter);
						printNaborSkleyka(enter, nabor.getKey());
						result = ruleSkleykaII(enter, left, right, parameters, nextnumber + 1, result);			 
					} else if (left != nabor.getValue().getKey().length-1 || right != nabor.getValue().getKey().length-1) {
						result = ruleSkleykaII(nabor, left, right, parameters, nextnumber, bag); 
					} 
				}				
			}
		} 
		return result;
	}
	
	public void printNaborSkleyka(Entry<String, Entry<int[], HashSet<String>>> nabor, String analysis) {
		// print of number of nabor
		System.out.print(nabor.getKey() + ". ");				 					
		// print of nabor
		printEntry(nabor.getValue());
		// print analysis "A"
		System.out.print(" " + analysis + ", Skleyka");	
	}
	
	public void printEntry(Entry<int[], HashSet<String>> e) {
		// print of elems of nabor
		int[] elems = e.getKey();									
		//System.out.println();
		System.out.print("{");										
		for (int ros=0; ros<elems.length; ros++) {					
			if (ros==0) {						 	  				
				System.out.print(elems[ros]);							
			} else {												
				System.out.print(", " + elems[ros]);					
			}														
			if (ros==elems.length-1) {						 		
				System.out.print(" | ");							
			}														
		}															
		// print of svjazka of nabor
		String[] setArray = e.getValue().toArray(new String[e.getValue().size()]);
		for (int d=0; d<setArray.length; d++) {						
			if (d==setArray.length-1) {						 		
				System.out.print(setArray[d] + "}");							
			} else {														
				System.out.print(setArray[d] + ", ");					
			}
		}																
	}
	
	public HashSet<String> subtractIndexes(HashSet<String> set, int index) {
		
		HashSet<String> result = new HashSet<String>();
		
		Iterator<String> itr = set.iterator();
		while (itr.hasNext()) {
			String s = replaceNumInStr(itr.next(), 0, index);
			result.add(s);
		}
		return result;
	}
	
	public String replaceNumInStr(String s, int ind, int num) {
		String result;
		if (s.contains("^") && s.indexOf("^", ind) > 0) {
			int index = s.indexOf("^", ind);
			String s1 = s.substring(0, index+1);
			index++;
			String s2 = "";
			while (index < s.length() && Character.isDigit(s.charAt(index))) {
				s2 += s.charAt(index++);
			}
			int inum = Integer.parseInt(s2, 10);
			if (inum > num) {
				s2 = Integer.toString(inum - 1);
			}	
			result = replaceNumInStr(s1 + s2 + s.substring(index), index, num);	// recursion			
		} else {
			result = s;
		}
		return result;
	}
		
	public int[] delElArray(int[] array, int index) {
		int[] result = new int[array.length-1];
		for (int i = 0; i < result.length; i++) {
			if (i < index-1) {
				result[i] = array[i];
			} else {
				result[i] = array[i+1];
			}
		}
		return result;
	}
		
	public boolean isEmptyIntersection(HashSet<String> set1, HashSet<String> set2) {
		
		boolean result;
		
		Set<String> intersection = new HashSet<String>(set1);
		intersection.retainAll(set2);
		if (intersection.isEmpty()) {
			result = true;
		} else {
			result = false;
		}
		return result;
	}
	
	public boolean isEqual(HashSet<String> set1, HashSet<String> set2) {
		
		boolean result;
		
		Set<String> difference1 = new HashSet<String>(set1);
		difference1.removeAll(set2);
		Set<String> difference2 = new HashSet<String>(set2);
		difference2.removeAll(set1);
		if (difference1.isEmpty() && difference2.isEmpty()) {
			result = true;
		} else {
			result = false;
		}
		return result;
	}
	
	public HashSet<String> createNewSviazka(HashSet<String> sviazka, int[] elem, String[] parameters) {
		
		HashSet<String> result = new HashSet<String>(); 
		
		upgradClassEquiv(sviazka, elem, parameters); 	// after this step classEquiv holds classes of equivalences
		
		if (isAdmissible()) { 							// is classEquiv is admissble?
			HashSet<String> minusSet = deletingSet(elem, parameters);
			deleteSet(minusSet);
			
			HashSet<String> newSviazka = new HashSet<String>();
			
			Set<Entry<Integer, HashSet<String>>> entrySet = classEquiv.entrySet();	
			for (Entry<Integer, HashSet<String>> e: entrySet) {
				if (e.getValue().size() > 1) {
					HashSet<String> newEq = constructEquations(e.getValue());
					newSviazka.addAll(newEq);
				}
			}
			result = newSviazka;
		} else { 										// return the same sviazka
			result = sviazka;
		}
		return result;
	}	
	
	public HashSet<String> constructEquations(HashSet<String> set) {
		
		HashSet<String> result = new HashSet<String>();
		
		String defs = "";
		boolean check = false;
		Iterator<String> itr = set.iterator();
		while (itr.hasNext()) {
			String next = itr.next(); 			
			if (Character.getNumericValue(next.charAt(0)) < 24) {
				defs = next;
				check = true;
				break;
			} else if (Character.getNumericValue(next.charAt(0)) > 24 && check == false) {
				defs = next;				
			}
		}
		Iterator<String> itr2 = set.iterator();
		while (itr2.hasNext()) {
			String str = itr2.next();
			if (!str.equals(defs)) {
				String s = str + "=" + "[" + defs + "]";
				result.add(s);
			} 
		}		
		return result;
	}
	
	public void deleteSet(HashSet<String> minusSet) {
		
		for (int i = 0; i < classEquiv.size(); i++) {
			HashSet<String> set = classEquiv.get(i);
			set.removeAll(minusSet); 	
			}	
	}	
		
	public HashSet<String> deletingSet(int[] elem, String[] parameters) {
		
		HashSet<String> set = new LinkedHashSet<String>(); 
		
		for (int i = 0; i < parameters.length; i++) {
			String s = parameters[i] + "^" + Integer.toString(elem[elem.length-1]);
			set.add(s);
		}
		return set;
	}
		
	public boolean isAdmissible() { // is classEquiv holds classes of equivalences that have decision?
		
		boolean result = true;
		
		Set<Entry<Integer, HashSet<String>>> classEq = classEquiv.entrySet();	
		
		for (Entry<Integer, HashSet<String>> e: classEq) {
			int cnt = 0;
			Iterator<String> itr = e.getValue().iterator();
			while (itr.hasNext()) {
				if (Character.getNumericValue(itr.next().charAt(0)) < 24) { // String begininnig with constantic letter, i.e. it is constant, 24 is number of 'o'
					cnt++;
				}				
			}
			if (cnt > 1) {
				result = false;
				break;
			} 			
		}
		return result;	
	}
		
	public void upgradClassEquiv(HashSet<String> sviazka, int[] elem, String[] parameters) {
			
		upgradSviazka(elem, parameters);
		
		int next = classEquiv.size();
		
		Iterator<String> itr = sviazka.iterator();
		while (itr.hasNext()) {
			boolean check = false;
			String s = itr.next();
			//System.out.print("\n" + s + ". ");
			HashSet<String> setFromEq = transformEqToSet(s);
		
			for (int i = 0; i < classEquiv.size(); i++) {
				HashSet<String> setAdd = classEquiv.get(i);
				if (!isEmptyIntersection(setFromEq, setAdd)) {
					Iterator<String> itrS = setFromEq.iterator();
					while (itrS.hasNext()) {
						setAdd.add(itrS.next());
					}
					check = true;
				}				
			}
			if (check == false) {
				classEquiv.put(next, setFromEq);
				next++;
			}		
		}
		metaUpgradClassEquiv();
	}

	public void metaUpgradClassEquiv() {	
		
		boolean check = false;
		
		for (int i = 0; i < classEquiv.size(); i++) {
			HashSet<String> set1 = classEquiv.get(i);
			for (int j = i+1; j < classEquiv.size(); j++) {
				HashSet<String> set2 = classEquiv.get(j);
			
				if (!isEmptyIntersection(set1, set2)) {
					Iterator<String> itr = set2.iterator();
					while (itr.hasNext()) {
						set1.add(itr.next());
					}
					check = true;
					// metaupdate ClassEquiv:
					//classEquiv.remove(j);										
					for (int k = j; k < classEquiv.size()-1; k++) { // rewriting classEquiv
						HashSet<String> setNext = classEquiv.get(k+1);
						classEquiv.put(j, setNext);
					}
					classEquiv.remove(classEquiv.size()-1); //remove last
				}
			}	
		}
		
		if (check == true) { // if changed then do recursive call of function
			metaUpgradClassEquiv();
		}
	}
	
	public HashSet<String> transformEqToSet(String eqiv) {
		String subEqiv1 = eqiv.substring(0, eqiv.indexOf("="));
		String subEqiv2 = eqiv.substring(eqiv.indexOf("=")+2, eqiv.length()-1);
		HashSet<String> result = new LinkedHashSet<String>();
		result.add(subEqiv1);
		result.add(subEqiv2);
		return result;
	}
		
	public void upgradSviazka(int[] elem, String[] parameters) { // in skleyka elem -- 2 number of ident elem of nabor
																				// in ruleB   elem -- whole number of deleting elems of nabors
		classEquiv = new LinkedHashMap<Integer, HashSet<String>>();				// parameters any in both cases -- Vars of this Formula	
		
		for (int i = 0; i < parameters.length; i++) {
			HashSet<String> set = new LinkedHashSet<String>(); 
			for (int j = 0; j < elem.length; j++) {
				String s = parameters[i] + "^" + Integer.toString(elem[j]);
				set.add(s);
			}
			classEquiv.put(i, set);
		}		
	}
	
	
	
	public static void main(String[] args) {

		Skleyka skl = new Skleyka();
		
		skl.naboren = new HashMap<String, Entry<int[], HashSet<String>>>();
		skl.naboro = new HashMap<int[], HashSet<String>>();
		
		//String[] parameters = new String[]{"x", "y", "z"};
		String[] parameters = new String[]{"x", "y"};
		//int[] elem = new int[]{1, 2};
		int[] comp = new int[]{1, 1, 2, 2};
		//int[] comp = new int[]{2, 2};
		
		//skl.upgradSviazka(elem, parameters);

		//String s = "x^1=[a]";
		//String s1 = "y^1=[b]";
		//String s2 = "w^1=[b]";
		//String s3 = "w^1=[e]";
		//String s4 = "z^2=[a]";
		String s1 = "x^1=[b]";
		String s2 = "x^2=[b]";
		String s3 = "y^3=[a]";
		String s4 = "y^4=[a]";
		//Set<String> set = skl.transformEqToSet(s);
		//Iterator<String> itr2 = set.iterator();
		//while (itr2.hasNext()) {
		//	System.out.print("\n" + itr2.next() + ". ");
		//}	
		
		HashSet<String> sviazka = new HashSet<String>();
		//sviazka.add(s); 
		sviazka.add(s1); 
		sviazka.add(s2); 
		sviazka.add(s3);
		sviazka.add(s4); 
		
		skl.naboro.put(comp, sviazka);
		
		Set<Entry<int[], HashSet<String>>> nabs = skl.naboro.entrySet();
		
		for (Entry<int[], HashSet<String>> e: nabs) {
			skl.naboren.put("1", e);
			
		}
		
		Set<Entry<String, Entry<int[], HashSet<String>>>> nabswithn = skl.naboren.entrySet();
		LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> bag = new LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>>();
		
		for (Entry<String, Entry<int[], HashSet<String>>> nabor: nabswithn) {
			skl.printNaborSkleyka(nabor, " ");
			LinkedHashSet<Entry<String, Entry<int[], HashSet<String>>>> go = skl.ruleSkleykaII(nabor, 0, 1, parameters, 2, bag);
			Iterator<Entry<String, Entry<int[], HashSet<String>>>> iter = go.iterator();
			while (iter.hasNext()) {
				Entry<String, Entry<int[], HashSet<String>>> follows = iter.next();
				for (int i = 0; i < follows.getValue().getKey().length; i++) {
					//System.out.print("\n" + follows.getValue().getKey()[i] + ". ");
				}
				Iterator<String> itr = follows.getValue().getValue().iterator();
				while (itr.hasNext()) {
				//	System.out.print("\n" + itr.next() + ". ");
				}
			
			}
			

		}		
		
		//HashSet<String> sviazka1 = new HashSet<String>(sviazka);
		
		//sviazka1.add(s3);
		
		//HashSet<String> minusSet = new HashSet<String>();
		//minusSet.add("x^2");
		//minusSet.add("y^2");
		//minusSet.add("z^2");
		
		//skl.upgradClassEquiv(sviazka, elem, parameters);
		//skl.deleteSet(minusSet);
		// print classEquiv:
		
		/*
		Set<Entry<Integer, HashSet<String>>> entrySet = skl.classEquiv.entrySet();
		for (Entry<Integer, HashSet<String>> e : entrySet) {					
			// print of number of elem. razbibka
			System.out.print("\n");
			System.out.print("\n" + e.getKey() + ". ");
			// print of set
			Iterator<String> itr = e.getValue().iterator();
			while (itr.hasNext()) {
				String str = itr.next();
				System.out.print("\n" + str + " " + Character.getNumericValue(str.charAt(0)) + " " + (Character.getNumericValue(str.charAt(0))<24) +  ". ");
				
			}
						
			//HashSet<String> news = skl.constructEquations(e.getValue());
			
			//Iterator<String> itr2 = news.iterator();
			//while (itr2.hasNext()) {
			//	String str = itr2.next();
			//	System.out.print("\n" + str + ". ");
				
			//}
		}
		*/
		//System.out.print(skl.isEqual(sviazka, sviazka1));
		//System.out.print(skl.isAdmissible());
		/*
		HashSet<String> newsv = skl.createNewSviazka(sviazka, elem, parameters);
		System.out.print("\n" + "size is: " + newsv.size() + ". ");
		Iterator<String> it = newsv.iterator();
		while (it.hasNext()) {
			//String str = it.next();
			System.out.print("\n" + it.next() + ". ");			
		}
		*//*
		int[] array = new int[]{1,2,3,4,5,6,7,8,9,0};
		int index = 4;
		int[] ar = skl.delElArray(array, index);
		for (int i = 0; i < ar.length; i++) {
			System.out.println(ar[i] + ", ");
		}*/
		/*
		String s = "x^4=[a]";
		int num = 5;		
		System.out.println(skl.replaceNumInStr(s, 0, num));
		*/
	}

}
