from xbee import XBee
from serial import Serial
from decimal import Decimal
from threading import Thread

DEST_ADDR_LONG2 = "\x00\x13\xA2\x00\x40\xA1\xF8\x66"  # black #com3 #node22 #dest_addrlow = 01 #comp
PORT = 'COM3'
BAUD = 9600

ser = Serial(PORT, BAUD)
xbee = XBee(ser, escaped=True)

#
#   Receive Command from XBee
#
def receive():
    while True:
        try:
            response = xbee.wait_read_frame()
            print response
            
            arr = response['rf_data'].split(";")
            if len(arr) == 0:
                continue
                                         
            if arr[0] == "t" and len(arr)==5:
                #print "received " + response['rf_data']
                fromq = arr[1]
                lat = arr[2]
                lon = arr[3]
                alt = arr[4]
                
                print fromq
                print lat
                print lon
                print alt
                
        except KeyboardInterrupt:
            #break
            exit()

print "Start receiving commands"
t1 = Thread(target=receive, args=())
t1.start()

#while True: xbee.send("tx", data="t;1;2;3;4", dest_addr_long=DEST_ADDR_LONG2, dest_addr="\x00\x00")
xbee.send("tx", data="t;1;2;3;4", dest_addr_long=DEST_ADDR_LONG2, dest_addr="\x00\x00")         


