from xbee import XBee
from serial import Serial
from threading import Thread

#hardcode start
DEST_ADDR_LONG1 = "\x00\x13\xA2\x00\x40\xA1\xF8\x66"  #port1
DEST_ADDR_LONG2 = "\x00\x13\xA2\x00\x40\x9C\x14\xF9"  #port2
PORT1 = 'COM10'
PORT2 = 'COM12'

addrs = ['\x00\x13\xA2\x00\x40\xA1\xF8\x66', '\x00\x13\xA2\x00\x40\x9C\x14\xF9']
ports = ['COM10','COM12']

#hardcode end
BAUD = 9600

def send(message, i):
    xbee.send("tx", data=message, dest_addr_long=addrs[i], dest_addr="\x00\x00")

def receive():
    while True:
        try:
            response = xbee.wait_read_frame()
            rec_func(response['rf_data'])
            #print 
            
        except KeyboardInterrupt:
            #break
            exit()

            
def init(i, receive_func):
    global rec_func
    global ser
    global xbee
    ser = Serial(ports[i], BAUD)
    xbee = XBee(ser, escaped=True)
    rec_func = receive_func
    
    print "Start receiving commands"
    t1 = Thread(target=receive, args=())
    t1.start()







