
import sys
import os
from struct import pack, unpack
from math import sqrt
from random import randint

class Agent:
    pass

class Token:
    pass

global agent_list
global token
global agent_count
global synd_count
global photo_count
global local_voting_param
global compare_param
global timeout_param

timeout_param = 100
compare_param = 0.4
local_voting_param = 0.1
agent_list = []
synd_agent = []
agent_count = int(sys.argv[1])
stripe_count = int(sys.argv[2])
synd_count = int(sys.argv[3])
token = Token()

for agent_num in range(agent_count):
    agent = Agent()
    agent.number = agent_num
    agent_list.append(agent)

def init_agents():
    for agent in agent_list:
        agent.average = []
        agent.tmp_average = []

def is_neighbor_ring_topology(agent, agent_neighbor, count):
    if count % 2 == 0:
        if ((agent.number % 2 == 0 and
             (abs(agent.number - agent_neighbor.number) == 1 or
              abs(agent.number - agent_neighbor.number) == agent_count - 1) and
             agent.number < agent_neighbor.number) or
            (agent.number % 2 == 1 and
             (abs(agent.number - agent_neighbor.number) == 1 or
              abs(agent.number - agent_neighbor.number) == agent_count - 1) and
             agent.number > agent_neighbor.number)):
            return True
    elif count % 2 == 1:
        if ((agent.number % 2 == 0 and
             abs(agent.number - agent_neighbor.number) == 1 and
             agent.number > agent_neighbor.number) or
            (agent.number % 2 == 1 and
             abs(agent.number - agent_neighbor.number) == 1 and
             agent.number < agent_neighbor.number)):
            return True
    return False

def is_neighbor_cell_topology(agent, agent_neighbor, count):
    if (abs(agent.number - agent_neighbor.number) == 1 or
        abs(agent.number - agent_neighbor.number) == int(sqrt(agent_count)) or
        abs(agent.number - agent_neighbor.number) == int(sqrt(agent_count)) - 1 or
        abs(agent.number - agent_neighbor.number) == int(sqrt(agent_count)) + 1):
        return True
    return False
    
def is_neighbor_all_topology(agent, agent_neighbor, count):
    if agent.number != agent_neighbor.number:
        return True
    return False

def init_token(token, stripe_num):
    token.agent_num = 0
    token.agent_size = 0
    token.count = 0
    token.state = 'check'
    token.average = []
    token.fsize = []
    token.synd_agent = []
    for synd_num in range(synd_count):
        token.synd_agent.append((stripe_num + synd_num) % agent_count)
    
def write_meta(token, stripe_num):
    str = ''
    for fsize in token.fsize:
        str += pack('I', fsize)

    fname = '{}/{}.meta'.format(token.agent_num, stripe_num)
    file = open(fname, 'wb')
    file.write(str)
    file.close()

def read_file(token, agent, stripe_num, synd_num):
    for synd_agent_num in token.synd_agent:
        if synd_agent_num == token.agent_num:
            for data_num in range(token.agent_size):
                agent.average.append(0.0)
                agent.tmp_average.append(0.0)
            return

    fname = '{}/{}.png'.format(token.agent_num, stripe_num)
    if not os.path.exists(fname):
        print 'File {} is not found!'.format(fname)
        return
    file = open(fname, 'rb')
    bytes = file.read()
    file.close()

    bcount = len(bytes)
    agent.average = []
    for data_num in range(token.agent_size):
        if (data_num + 1) * 4 <= bcount:
            data = bytes[data_num * 4:(data_num + 1) * 4]
            number = unpack('I', data)[0]
        elif data_num * 4 <= bcount:
            data = bytes[data_num * 4:]
            data = data.ljust(4, '\x00')
            number = unpack('I', data)[0]
        else:
            number = 0
        agent.average.append(((synd_num + 1)**token.agent_num) * float(number))
        agent.tmp_average.append(0.0)

def write_syndrom(token, agent, stripe_num, synd_num):
    if token.agent_num != token.synd_agent[synd_num]:
        return

    bytes = ''
    for average in agent.average:
        bytes += pack('Q', int(round(average * agent_count)))

    fname = '{}/{}.synd'.format(token.agent_num, stripe_num)
    file = open(fname, 'wb')
    file.write(bytes)
    file.close()

def check_file(token, stripe_num):
    for synd_agent_num in token.synd_agent:
        if synd_agent_num == token.agent_num:
            return
    
    fname = '{}/{}.png'.format(token.agent_num, stripe_num)
    if os.path.exists(fname):
        fsize = os.path.getsize(fname)
        token.fsize.append(fsize)
        if fsize > token.agent_size:
            token.agent_size = fsize
    else:
        print 'File {} is not found!'.format(fname)

def local_voting_calculate(token, agent):
    for data_num in range(token.agent_size):
        agent.tmp_average[data_num] = 0.0
        for agent_neighbor in agent_list:
            if is_neighbor_all_topology(agent, agent_neighbor, token.count) == True:
                agent.tmp_average[data_num] += agent.average[data_num] - agent_neighbor.average[data_num]
        agent.tmp_average[data_num] = agent.average[data_num] - local_voting_param * agent.tmp_average[data_num]

def calculate_syndrom(stripe_num, synd_num):
    init_agents()
    init_token(token, stripe_num)

    while True:
        agent = agent_list[token.agent_num]
        
        if token.state == 'check':
            check_file(token, stripe_num)
            
            if token.agent_num == agent_count - 1:
                token.agent_size = (token.agent_size + 3) / 4
                token.state = 'init'
                token.agent_num = 0
            else:
                token.agent_num += 1
            continue
        
        if token.state == 'init':
            read_file(token, agent, stripe_num, synd_num)
            
            if token.agent_num == agent_count - 1:
                token.state = 'calculate'
                token.agent_num = 0
            else:
                token.agent_num += 1
            continue

        if token.state == 'write syndrom':
            write_syndrom(token, agent, stripe_num, synd_num)
            write_meta(token, stripe_num)
            
            if token.agent_num == agent_count - 1:
                break
            else:
                token.agent_num += 1
            continue

        if token.state == 'calculate':
            local_voting_calculate(token, agent)

            if token.agent_num == agent_count - 1:
                token.state = 'end all'
                token.agent_num = 0
            else:
                token.agent_num += 1
            continue

        for number in range(token.agent_size):
            agent.average[number] = agent.tmp_average[number]
        
        if token.agent_num == 0:
            if len(token.average) == 0:
                for number in range(token.agent_size):
                    token.average.append(0.0)
            for number in range(token.agent_size):
                token.average[number] = agent.average[number]
        elif token.count < timeout_param:
            for number in range(token.agent_size):
                if abs(token.average[number] - agent.average[number]) * (agent_count**2) > compare_param:
                    token.state = 'end tick'
                token.average[number] = agent.average[number]
        
        if token.agent_num == agent_count - 1:
            token.count += 1
            if token.state == 'end all':
                token.state = 'write syndrom'
                token.agent_num = 0
            else:
                token.state = 'calculate'
                token.agent_num = 0
        else:
            token.agent_num += 1

    # print 'Sum centralized ' + str(token.sum_centralized)
    # print 'Sum decentralized ' + str(token.sum_decentralized)
    # print 'Count decentralized ' + str(token.count)

for stripe_num in range(stripe_count):
    for synd_num in range(synd_count):
        calculate_syndrom(stripe_num, synd_num)
