﻿// HaarTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "opencv2/objdetect/objdetect.hpp"
#include "opencv2/highgui/highgui.hpp"
#include "opencv2/imgproc/imgproc.hpp"

#include <fstream>
#include <iostream>
#include <stdio.h>
#include <map>

using namespace std;
using namespace cv;

int countPl = 0;

void readGroundTruthFromFile(std::string path, std::map<int, std::vector<cv::Rect>>& plates, bool dayWithAcc = false){
	std::ifstream platesFile(path); //open file
	//printf("opened\n");
	while (!platesFile.eof()){
		std::string line;
		std::getline(platesFile, line); 
		if (line.length() < 1) continue;
		istringstream iss(line);

		int frameNum;
		cv::Rect plate;
		bool good;

		std::vector<string> tokens;
		copy(istream_iterator<string>(iss),
			istream_iterator<string>(),
			back_inserter(tokens));

		try{
			frameNum = std::stoi(tokens[0]);
			plate = cv::Rect(std::stoi(tokens[1]),
				std::stoi(tokens[2]),
				std::stoi(tokens[3]),
				std::stoi(tokens[4]));
			if (tokens.size() < 7){
				good = 1;
			}
			else{
				good = std::stoi(tokens[6]) == 1 ? true : false;
			}
		}
		catch (...){
			continue;
		}

		if(good) plates[frameNum].push_back(plate);
	}
	platesFile.close();
	if (dayWithAcc){
		for (int i = 640; i < 1097; i++){
			std::vector<cv::Rect> curr = plates[i];
			bool cont1 = false;
			bool cont2 = false;
			cv::Rect r1 = cv::Rect(1530, 607, 98, 25);
			cv::Rect r2 = cv::Rect(1180, 506, 96, 28);
			for each (auto &r in curr){
				int r1Int = (r & r1).area();
				double r11 = ((double)r1Int) / ((double)r.area());
				double r12 = ((double)r1Int) / ((double)r1.area());
				double currIntersect1 = r11 < r12 ? r11 : r12;

				int r2Int = (r & r2).area();
				double r21 = ((double)r2Int) / ((double)r.area());
				double r22 = ((double)r2Int) / ((double)r2.area());
				double currIntersect2 = r21 < r22 ? r21 : r22;

				if (currIntersect1 > 0.5){
					cont1 = true;
					break;
				}

				if (currIntersect2 > 0.5){
					cont2 = true;
					break;
				}
			}
			if (!cont1){
				plates[i].push_back(r1);
			}
			if (!cont2){
				plates[i].push_back(r2);
			}
		}
	}
}

std::pair<int, int> checkFrameDetections(std::vector<cv::Rect> truePlates, std::vector<cv::Rect>& detected){
	int detectedTrueNumb = 0;

	std::vector<bool> matchedDets = std::vector<bool>(detected.size(), false);
	std::vector<cv::Rect> bestRects;

	for each(auto &trP in truePlates){
		double bestIntersect = 0;
		cv::Rect bestR = cv::Rect(0, 0, 10, 10);
		int n = 0;
		for each(auto &det in detected){
			int intersectArea = (trP & det).area();
			double r1 = ((double)intersectArea) / ((double)trP.area());
			double r2 = ((double)intersectArea) / ((double)det.area());
			double currIntersect = r1 < r2 ? r1 : r2;//((double) intersectArea) / ((double) unionArea);
			if (currIntersect > bestIntersect) {
				bestIntersect = currIntersect;
				bestR = det;
			}
			if (currIntersect > 0.5) matchedDets[n] = true;
			n++;
		}
		if (bestIntersect > 0.5) {
			detectedTrueNumb++; 
		}
		bestRects.push_back(bestR);
	}

	int falsePosNumb = 0;
	for each(bool m in matchedDets){
		if (!m) falsePosNumb++;
	}
	//detected = bestRects;

	return std::make_pair(detectedTrueNumb, falsePosNumb);
}

std::vector<cv::Rect> getSmall(std::vector<cv::Rect> truePl){
	std::vector<cv::Rect> res;
	for each(auto &r in truePl){
		res.push_back(cv::Rect(r.x / 2, r.y / 2, r.width / 2, r.height / 2));
	}
	return res;
}
//pair<time to process, tuple<detected True, false Positive, processed Windows>>
std::pair<double, std::tuple<int, int, long long>> processFrame(CascadeClassifier cascade, cv::Mat& frame, std::vector<cv::Rect> truePl, bool sparseStep, int winNumb = -1, bool useSmall = false){
	std::vector<cv::Rect> objects;
	int64 *windows = new long long;
	(*windows) = 0;

	int64 t = cv::getTickCount();
	if (cascade.getOriginalWindowSize().width == 24 || useSmall){
		cv::Mat frameSmall;
		cv::resize(frame, frameSmall, cv::Size(frame.cols / 2, frame.rows / 2));
		cascade.detectMultiScale(frameSmall, objects, 1.2, 0, 0, cv::Size(24, 6), cv::Size(80, 20), false, windows);
	} else if (sparseStep){
		cascade.detectMultiScale(frame, objects, 1.2, 0, 0, cv::Size(48, 12), cv::Size(160, 40), true, windows);
	}
	else {
		cascade.detectMultiScale(frame, objects, 1.2, 0, 0, cv::Size(48, 12), cv::Size(160, 40), false, windows);
	}
	int64 t2 = cv::getTickCount() - t;
	double tProc = ((double)t2) / cv::getTickFrequency();

	std::pair<int, int> res;
	if (cascade.getOriginalWindowSize().width == 24 || useSmall){
		std::vector<cv::Rect> smallTrue = getSmall(truePl);
		res = checkFrameDetections(smallTrue, objects);
	}
	else {
		res = checkFrameDetections(truePl, objects);
	}

	/*std::pair<int, int> res = std::make_pair(0,0);
	double tProc = 1.0;

	for (int i = 0; i < truePl.size(); i++){
		int marg = ((double)truePl[i].height) / 2.5;
		cv::Rect r = cv::Rect(truePl[i].x - marg, truePl[i].y - marg, truePl[i].width + marg * 2, truePl[i].height + marg * 2);
		if (r.x > frame.cols || r.y > frame.rows || r.x < 0 || r.y < 0
			|| r.x + r.width > frame.cols || r.y + r.height > frame.rows) continue;
		cv::Mat toSave;
		cv::resize(frame(r), toSave, cv::Size(58, 22));
		cv::imwrite("C:\\testImgsPlates\\" + std::to_string(countPl) + ".bmp", toSave);
		countPl++;
	}*/

	if (winNumb != -1){
		cv::Mat toShow;
		//printf("image size = %d, %d\n", frame.cols, frame.rows);
		if (frame.channels() > 1){
			frame.copyTo(toShow);
		}
		else{
			cv::cvtColor(frame, toShow, CV_GRAY2BGR);
		}
		for (int i = 0; i < objects.size(); i++)
		{
			rectangle(toShow, objects[i], cv::Scalar(50, 0, 0));
		}
		for (int i = 0; i < truePl.size(); i++)
		{
			rectangle(toShow, truePl[i], cv::Scalar(0, 0, 255));
		}
		cv::resize(toShow, toShow, cv::Size(toShow.cols / 2, toShow.rows/2));
		cv::imshow("cascade" + std::to_string(winNumb), toShow);
		cv::waitKey(1);
		int hk; scanf("%d", &hk);
	}

	return std::make_pair(tProc, make_tuple(res.first, res.second, (*windows)));
}

void processVideo(std::vector<CascadeClassifier>& cascades, std::vector<bool> useSparse, std::string pathToVideo, std::string pathToGroundTruth
	, std::vector<int>& allDetectedTrue, int& allTrue, std::vector<int>& allFalsePos, std::vector<long long>& allWindows, std::vector<double>& allTime, int& framesProcessed, int framesToProc){
	//printf("VIDEO\n");
	cv::VideoCapture video(pathToVideo);
	std::map<int, std::vector<cv::Rect>> truePl;

	//printf("readGroundTruth\n");
	readGroundTruthFromFile(pathToGroundTruth, truePl);
	//printf("end reading\n");
	cv::Mat frame;
	video >> frame;

	int frNumb = 0;

	while (!frame.empty() && frNumb < framesToProc){
		printf("frNumb : %d\n", frNumb);

		//if (frNumb < 10) { frNumb++; continue; }
		//if (frNumb > 100) break;

		for (int i = 0; i < cascades.size(); i++){
			bool useSmall = (i == 7);
			std::pair<double, std::tuple<int, int, long long>> res = processFrame(cascades[i], frame, truePl[frNumb], useSparse[i], -1, useSmall);
			allTime[i] += res.first;
			allDetectedTrue[i] += std::get<0>(res.second);
			allFalsePos[i] += std::get<1>(res.second);
			allWindows[i] += std::get<2>(res.second);
			if(i == 0) allTrue += truePl[frNumb].size();
			//printf("all true: %d; detected: %d; falsePos: %d; all windows: %d;\n", allTrue, allDetectedTrue[i], allFalsePos[i], allWindows[i]);
		}

		//if (frNumb < 10) continue;

		frNumb++;
		framesProcessed++;
		video >> frame;
	}
}

void processSeq(std::vector<CascadeClassifier>& cascades, std::vector<bool> useSparse, std::string path, std::string pathToGroundTruth
	, std::vector<int>& allDetectedTrue, int& allTrue, std::vector<int>& allFalsePos, std::vector<long long>& allWindows, std::vector<double>& allTime, int& framesProcessed, bool dayWithAcc = false){

	std::ifstream frames(path);
	std::map<int, std::vector<cv::Rect>> truePl;
	readGroundTruthFromFile(pathToGroundTruth, truePl, dayWithAcc);

	while (!frames.eof()){

		std::string line;
		std::getline(frames, line);

		cv::Mat frame = cv::imread(line);

		int frNumb = std::stoi(line.substr(line.length() - 8, 4));//10; ////parse numb
		printf("frNumb : %d\n", frNumb);

		for (int i = 0; i < cascades.size(); i++){
			
			bool useSmall = (i == 7);
			std::pair<double, std::tuple<int, int, long long>> res = processFrame(cascades[i], frame, truePl[frNumb], useSparse[i], -1, useSmall);
			allTime[i] += res.first;
			allDetectedTrue[i] += std::get<0>(res.second);
			allFalsePos[i] += std::get<1>(res.second);
			allWindows[i] += std::get<2>(res.second);
			if(i == 0) allTrue += truePl[frNumb].size();
		}
		framesProcessed++;
	}
}

//добавить в detectMultiScale подсчет количества обработанных окон
void test(int testNumb){
	std::vector<string> pathToTruePl;
	std::vector<string> pathToVideos;
	std::vector<string> pathToSeq;
	
	//std::vector<CascadeClassifier> cascades;
	//std::vector<bool> useSparse;

	std::vector<CascadeClassifier> cascades;
	std::vector<bool> useSparse;
	std::vector<std::string> names;

	//каскады
	/*CascadeClassifier cascade015;
	cascade015.load("C:\\training\\cascadesAdjusted\\train_res_015\\cascade.xml");
	cascades.push_back(cascade015);
	useSparse.push_back(true);
	names.push_back("cascade_015");*/

	/*CascadeClassifier cascade008;
	cascade008.load("C:\\training\\cascadesAdjusted\\train_res_008\\cascade.xml");
	cascades.push_back(cascade008);
	useSparse.push_back(true);
	names.push_back("cascade_008");*/

	/*CascadeClassifier cascade03;
	cascade03.load("C:\\training\\cascadesAdjusted\\train_res_03\\cascade.xml");
	cascades.push_back(cascade03);
	useSparse.push_back(true);
	names.push_back("cascade_03");

	CascadeClassifier cascade045;
	cascade045.load("C:\\training\\cascadesAdjusted\\train_res_045\\cascade.xml");
	cascades.push_back(cascade045);
	useSparse.push_back(true);
	names.push_back("cascade_045");*/

	/*CascadeClassifier cascadeOrig;
	cascadeOrig.load("C:\\training\\cascadesAdjusted\\train_res_BIG\\cascade_5st.xml");
	cascades.push_back(cascadeOrig);
	useSparse.push_back(true);
	names.push_back("cascadeOrigSparse");

	CascadeClassifier cascadeOrig2;
	cascadeOrig2.load("C:\\training\\cascadesAdjusted\\train_res_BIG\\cascade_5st.xml");
	cascades.push_back(cascadeOrig2);
	useSparse.push_back(false);
	names.push_back("cascadeOrig");*/

	CascadeClassifier cascadeSmall;
	cascadeSmall.load("C:\\training\\cascadesAdjusted\\train_res_SMALL\\cascade.xml");
	cascades.push_back(cascadeSmall);
	useSparse.push_back(false);
	names.push_back("cascadeSmall");

	/*CascadeClassifier cascadeOrig3Small;
	cascadeOrig3Small.load("C:\\training\\train_res_BIG\\cascade_5st.xml");
	cascades.push_back(cascadeOrig3Small);
	useSparse.push_back(false);
	names.push_back("cascadeOrigResizedImgs");*/

	/*std::string video1 = "C:\\training\\old_video\\vid_day.avi";
	std::string trueDets1 = "C:\\training\\old_video\\day_1_1000.txt";

	std::string video2 = "C:\\training\\old_video\\vid_night.avi";
	std::string trueDets2 = "C:\\training\\old_video\\night_1_1000.txt";*/
	std::string video1 = "C:\\newVideo\\testVideos\\vid_day_full_cut.avi";
	std::string trueDets1 = "C:\\newVideo\\testVideos\\day_full_corrected.txt";
	int frNumb1 = 2501;

	std::string video2 = "C:\\newVideo\\testVideos\\vid_night_full_cut.avi";
	std::string trueDets2 = "C:\\newVideo\\testVideos\\night_full_corrected.txt";
	int frNumb2 = 2001;

	std::string seq1 = "C:\\training\\seq\\files.txt";
	std::string trueDetsSeq1 = "C:\\training\\seq\\detections.txt";

	std::string seq2 = "C:\\training\\seqNight\\files.txt";
	std::string trueDetsSeq2 = "C:\\training\\seqNight\\detections.txt";
	
	std::vector<int> allDetectedTrue(cascades.size(), 0);
	int allTrue = 0;

	std::vector<int> allFalsePos(cascades.size(), 0);
	std::vector<long long> allWindows(cascades.size(), 0);

	std::vector<double> allTime(cascades.size(), 0.0);
	int framesProcessed = 0;

	std::string resFile;
	if (testNumb == 0){
		processVideo(cascades, useSparse, video1, trueDets1, allDetectedTrue, allTrue, allFalsePos, allWindows, allTime, framesProcessed, frNumb1);
		resFile = "dayVideo.txt";
	}
	else if (testNumb == 1){
		processSeq(cascades, useSparse, seq1, trueDetsSeq1, allDetectedTrue, allTrue, allFalsePos, allWindows, allTime, framesProcessed, true);
		resFile = "daySeq.txt";
	}
	else if (testNumb == 2){
		processVideo(cascades, useSparse, video2, trueDets2, allDetectedTrue, allTrue, allFalsePos, allWindows, allTime, framesProcessed, frNumb2);
		resFile = "nightVideo.txt";
	}
	else if (testNumb == 3){
		processSeq(cascades, useSparse, seq2, trueDetsSeq2, allDetectedTrue, allTrue, allFalsePos, allWindows, allTime, framesProcessed);
		resFile = "nightSeq.txt";
	}
	
	for (int i = 0; i < cascades.size(); i++){
		printf("%s results: %f - trueRate, %f - falsePosRate, %f - avgTime;\n", names[i].c_str()
			, ((double)allDetectedTrue[i]) / ((double)allTrue)
			, ((double)allFalsePos[i]) / ((double)allWindows[i])
			, allTime[i] / ((double)framesProcessed));
		std::ofstream res("C:\\training\\results\\" + names[i] + "_" + resFile);
		res << names[i] << ": ";
		res << "detected true: " << allDetectedTrue[i];
		res << ", all true: " << allTrue;
		res << ", all false pos: " << allFalsePos[i];
		res << ", all windows: " << allWindows[i];
		res << ", all time: " << allTime[i];
		res << ", frames processed: " << framesProcessed;
		res << ", trueRate: " << ((double)allDetectedTrue[i]) / ((double)allTrue);
		res << ", falseRate: " << ((double)allFalsePos[i]) / ((double)allWindows[i]);
		res << ", avgTime: " << allTime[i] / ((double)framesProcessed);
		res << "\n";
	}
	//summTrue
	//double allTime[], rates(truePositive, falsePositive)[]
	//для всех кадров обработать каскадами, вычислить rate, avarageTime
}

int _tmain(int argc, _TCHAR* argv[])
{
	test(0);
	//test(1);
	test(2);
	//test(3);

	return 0;

	Mat image;
	image = imread("C:\\training\\seq\\seq\\0100.bmp");
	//namedWindow("window1", 1);   imshow("window1", image);

	cv::Mat small;
	int64 tBR = cv::getTickCount();
	cv::resize(image, small, cv::Size(image.cols * 0.5, image.rows * 0.5), INTER_LINEAR);
	int64 tRes = cv::getTickCount() - tBR;
	double tRESIZE = ((double)tRes) / cv::getTickFrequency();

	cv::Mat integr;
	int64 tBI = cv::getTickCount();
	cv::integral(image, integr);
	int64 tIntegr = cv::getTickCount() - tBI;
	double tINTEGRAL = ((double)tIntegr) / cv::getTickFrequency();

	cv::Mat integrSm;
	int64 tBISM = cv::getTickCount();
	cv::integral(small, integrSm);
	int64 tIntegrSM = cv::getTickCount() - tBISM;
	double tINTEGRALSM = ((double)tIntegrSM) / cv::getTickFrequency();

	// Load Face cascade (.xml file)

	std::string oldC = "C:\\training\\train_res_BIG\\cascade_5st.xml";
	std::string newC = "C:\\training\\train_res\\cascade.xml";
	CascadeClassifier plate_cascade;
	plate_cascade.load(newC);

	CascadeClassifier plate_cascade_small;
	plate_cascade_small.load("C:\\training\\train_res_SMALL\\cascade.xml");

	// Detect faces
	std::vector<Rect> plates;
	std::vector<Rect> plates_small;
	
	int64 t = cv::getTickCount();
	plate_cascade.detectMultiScale(image, plates, 1.1, 0, 0, cv::Size(64, 16), cv::Size(160, 40), true);
	int64 tBig = cv::getTickCount() - t;
	double tB = ((double)tBig) / cv::getTickFrequency();

	int64 t2 = cv::getTickCount();
	//plate_cascade_small.detectMultiScale(small, plates_small, 1.2, 2, 0, cv::Size(32, 8), cv::Size(80, 20));
	int64 tSmall = cv::getTickCount() - t2;
	double tS = ((double)tSmall) / cv::getTickFrequency();

	printf("big time: %f;\nsmall time: %f;\nresize time: %f;\nintegral time: %f;\nintegral small time: %f;\n", tB, tS, tRESIZE, tINTEGRAL, tINTEGRALSM);

	printf("plates size: %d\n", plates.size());
	for (int i = 0; i < plates.size(); i++)
	{
		/*Point center(plates[i].x + plates[i].width*0.5, plates[i].y + plates[i].height*0.5);
		ellipse(image, center, Size(faces[i].width*0.5, faces[i].height*0.5), 0, 0, 360, Scalar(255, 0, 255), 4, 8, 0);*/
		rectangle(image, plates[i], cv::Scalar(0, 0, 0));
	}

	for (int i = 0; i < plates_small.size(); i++)
	{
		/*Point center(plates[i].x + plates[i].width*0.5, plates[i].y + plates[i].height*0.5);
		ellipse(image, center, Size(faces[i].width*0.5, faces[i].height*0.5), 0, 0, 360, Scalar(255, 0, 255), 4, 8, 0);*/
		rectangle(small, plates_small[i], cv::Scalar(0, 0, 0));
	}

	cv::Mat small2;
	cv::resize(image, small2, cv::Size(image.cols * 0.5, image.rows * 0.5), INTER_LINEAR);
	imshow("Detected plates", small2);
	
	waitKey(10);

	//imshow("Detected plates small", small);
	//imwrite("C:\\testImages\\img0.bmp", small);
	{waitKey(0); }

	return 0;
}
