#include "PseudopotentialTest.h"
#include "math.h"
#include "../Schrodinger/YuPotential.h"
#include <fstream>

std::vector<data_t> GaFormFactors;
std::vector<data_t> AlFormFactors;
std::vector<data_t> AsFormFactors;
std::vector<data_t> GaAsSymmetricFormFactors;
std::vector<data_t> AlAsSymmetricFormFactors;
std::vector<data_t> GaAsAsymmetricFormFactors;
std::vector<data_t> AlAsAsymmetricFormFactors;
std::vector<data_t> SiSymmetricFormFactor;
std::vector<data_t> SiAsymmetricFormFactor;
std::vector<data_t> GeSymmetricFormFactor; //asymemtric form factor for Ge is constant zero, so Si form factors are used
std::vector<data_t> GeSymmetricFormFactor1;
std::vector<data_t> GeSymmetricFormFactor2;
std::vector<data_t> GeSymmetricFormFactor3;
std::vector<data_t> GeSymmetricFormFactor4;
std::vector<data_t> GeSymmetricFormFactor5;
std::vector<data_t> GeSymmetricFormFactor6;

std::map< std::string, std::vector<data_t> > getSymmetricFormFactors() {
	initFormFactors();
	std::map< std::string, std::vector<data_t> > result;
	result["GaAs"] = GaAsSymmetricFormFactors;
	result["AlAs"] = AlAsSymmetricFormFactors;
	result["Si"] = SiSymmetricFormFactor;
	result["Ge"] = GeSymmetricFormFactor;
	result["Ge1"] = GeSymmetricFormFactor1;
	result["Ge2"] = GeSymmetricFormFactor2;
	result["Ge3"] = GeSymmetricFormFactor3;
	result["Ge4"] = GeSymmetricFormFactor4;
	result["Ge5"] = GeSymmetricFormFactor5;
	result["Ge6"] = GeSymmetricFormFactor6;
	return result;
}

std::map< std::string, std::vector<data_t> > getAsymmetricFormFactors() {
	initFormFactors();
	std::map< std::string, std::vector<data_t> > result;
	result["GaAs"] = GaAsAsymmetricFormFactors;
	result["AlAs"] = AlAsAsymmetricFormFactors;
	result["Si"] = SiAsymmetricFormFactor;
	result["Ge"] = SiAsymmetricFormFactor;
	result["Ge1"] = SiAsymmetricFormFactor;
	result["Ge2"] = SiAsymmetricFormFactor;
	result["Ge3"] = SiAsymmetricFormFactor;
	result["Ge4"] = SiAsymmetricFormFactor;
	result["Ge5"] = SiAsymmetricFormFactor;
	result["Ge6"] = SiAsymmetricFormFactor;
	return result;
}

void initFormFactors() {

	if (GaFormFactors.size() == 0) {
		//it has not been initialized yet
		GaFormFactors.push_back(-0.1114);
		GaFormFactors.push_back(-0.0750);
		GaFormFactors.push_back(-0.0560);
		GaFormFactors.push_back(-0.0454);
		GaFormFactors.push_back(-0.0345);
		GaFormFactors.push_back(-0.0230);
		GaFormFactors.push_back(-0.0125);
		GaFormFactors.push_back(-0.0030);
		GaFormFactors.push_back(0.0063);
		GaFormFactors.push_back(0.0160);
		GaFormFactors.push_back(0.0224);
		GaFormFactors.push_back(0.0241);
		GaFormFactors.push_back(0.0160);
		GaFormFactors.push_back(0.0060);
		GaFormFactors.push_back(0.0020);
		GaFormFactors.push_back(0.0);
		GaFormFactors.push_back(0.0);
	}
	if (AlFormFactors.size() == 0) {
		AlFormFactors.push_back(-0.1056);
		AlFormFactors.push_back(-0.0930);
		AlFormFactors.push_back(-0.0760);
		AlFormFactors.push_back(-0.0550);
		AlFormFactors.push_back(-0.0340);
		AlFormFactors.push_back(-0.0150);
		AlFormFactors.push_back(0.0025);
		AlFormFactors.push_back(0.0170);
		AlFormFactors.push_back(0.0240);
		AlFormFactors.push_back(0.0270);
		AlFormFactors.push_back(0.0260);
		AlFormFactors.push_back(0.0230);
		AlFormFactors.push_back(0.0200);
		AlFormFactors.push_back(0.0140);
		AlFormFactors.push_back(0.0080);
		AlFormFactors.push_back(0.0020);
		AlFormFactors.push_back(0.0);
	}
	if (AsFormFactors.size() == 0) {
		AsFormFactors.push_back(-0.1619);
		AsFormFactors.push_back(-0.1250);
		AsFormFactors.push_back(-0.0970);
		AsFormFactors.push_back(-0.0750);
		AsFormFactors.push_back(-0.0550);
		AsFormFactors.push_back(-0.0410);
		AsFormFactors.push_back(-0.0270);
		AsFormFactors.push_back(-0.0140);
		AsFormFactors.push_back(-0.0012);
		AsFormFactors.push_back(0.0060);
		AsFormFactors.push_back(0.0100);
		AsFormFactors.push_back(0.0125);
		AsFormFactors.push_back(0.0100);
		AsFormFactors.push_back(0.0090);
		AsFormFactors.push_back(0.0065);
		AsFormFactors.push_back(0.0030);
		AsFormFactors.push_back(0.0);
	}
	if (GaAsSymmetricFormFactors.size() == 0) {
		GaAsSymmetricFormFactors.push_back(0); //0
		GaAsSymmetricFormFactors.push_back(0); //1
		GaAsSymmetricFormFactors.push_back(0); //2
		GaAsSymmetricFormFactors.push_back(-0.252); //3
		GaAsSymmetricFormFactors.push_back(0); //4
		GaAsSymmetricFormFactors.push_back(0); //5
		GaAsSymmetricFormFactors.push_back(0); //6
		GaAsSymmetricFormFactors.push_back(0); //7
		GaAsSymmetricFormFactors.push_back(0); //8
		GaAsSymmetricFormFactors.push_back(0); //9
		GaAsSymmetricFormFactors.push_back(0); //10
		GaAsSymmetricFormFactors.push_back(0.08); //11
		GaAsSymmetricFormFactors.push_back(0); //12
		GaAsSymmetricFormFactors.push_back(0); //13
		GaAsSymmetricFormFactors.push_back(0); //15
		GaAsSymmetricFormFactors.push_back(0); //16
	}
	if (GaAsAsymmetricFormFactors.size() == 0) {
		GaAsAsymmetricFormFactors.push_back(0); //0
		GaAsAsymmetricFormFactors.push_back(0); //1
		GaAsAsymmetricFormFactors.push_back(0); //2
		GaAsAsymmetricFormFactors.push_back(0.068); //3
		GaAsAsymmetricFormFactors.push_back(0.066); //4
		GaAsAsymmetricFormFactors.push_back(0); //5
		GaAsAsymmetricFormFactors.push_back(0); //6
		GaAsAsymmetricFormFactors.push_back(0); //7
		GaAsAsymmetricFormFactors.push_back(0); //8
		GaAsAsymmetricFormFactors.push_back(0); //9
		GaAsAsymmetricFormFactors.push_back(0); //10
		GaAsAsymmetricFormFactors.push_back(0.012); //11
		GaAsAsymmetricFormFactors.push_back(0); //12
		GaAsAsymmetricFormFactors.push_back(0); //13
		GaAsAsymmetricFormFactors.push_back(0); //14
		GaAsAsymmetricFormFactors.push_back(0); //15
		GaAsAsymmetricFormFactors.push_back(0); //16
	}
	if (AlAsSymmetricFormFactors.size() == 0) {
		AlAsSymmetricFormFactors.push_back(0); //0
		AlAsSymmetricFormFactors.push_back(0); //1
		AlAsSymmetricFormFactors.push_back(0); //2
		AlAsSymmetricFormFactors.push_back(-0.26); //3
		AlAsSymmetricFormFactors.push_back(0); //4
		AlAsSymmetricFormFactors.push_back(0); //5
		AlAsSymmetricFormFactors.push_back(0); //6
		AlAsSymmetricFormFactors.push_back(0); //7
		AlAsSymmetricFormFactors.push_back(0.0456); //8
		AlAsSymmetricFormFactors.push_back(0); //9
		AlAsSymmetricFormFactors.push_back(0); //10
		AlAsSymmetricFormFactors.push_back(0.0710); //11
		AlAsSymmetricFormFactors.push_back(0); //12
		AlAsSymmetricFormFactors.push_back(0); //13
		AlAsSymmetricFormFactors.push_back(0); //14
		AlAsSymmetricFormFactors.push_back(0); //15
		AlAsSymmetricFormFactors.push_back(0); //16
	}
	if (AlAsAsymmetricFormFactors.size() == 0) {
		AlAsAsymmetricFormFactors.push_back(0); //0
		AlAsAsymmetricFormFactors.push_back(0); //1
		AlAsAsymmetricFormFactors.push_back(0); //2
		AlAsAsymmetricFormFactors.push_back(0.04); //3
		AlAsAsymmetricFormFactors.push_back(0.042); //4
		AlAsAsymmetricFormFactors.push_back(0); //5
		AlAsAsymmetricFormFactors.push_back(0); //6
		AlAsAsymmetricFormFactors.push_back(0); //7
		AlAsAsymmetricFormFactors.push_back(0); //8
		AlAsAsymmetricFormFactors.push_back(0); //9
		AlAsAsymmetricFormFactors.push_back(0); //10
		AlAsAsymmetricFormFactors.push_back(0.021); //11
		AlAsAsymmetricFormFactors.push_back(0.02); //12
		AlAsAsymmetricFormFactors.push_back(0); //13
		AlAsAsymmetricFormFactors.push_back(0); //14
		AlAsAsymmetricFormFactors.push_back(0); //15
		AlAsAsymmetricFormFactors.push_back(0); //16
	}
	if (SiSymmetricFormFactor.size() == 0) {
		SiSymmetricFormFactor.push_back(0); //0
		SiSymmetricFormFactor.push_back(0); //1
		SiSymmetricFormFactor.push_back(0); //2
		SiSymmetricFormFactor.push_back(-0.211); //3
		SiSymmetricFormFactor.push_back(0); //4
		SiSymmetricFormFactor.push_back(0); //5
		SiSymmetricFormFactor.push_back(0); //6
		SiSymmetricFormFactor.push_back(0); //7
		SiSymmetricFormFactor.push_back(0.04); //8
		SiSymmetricFormFactor.push_back(0); //9
		SiSymmetricFormFactor.push_back(0); //10
		SiSymmetricFormFactor.push_back(0.08); //11
		SiSymmetricFormFactor.push_back(0); //12
		SiSymmetricFormFactor.push_back(0); //13
		SiSymmetricFormFactor.push_back(0); //14
		SiSymmetricFormFactor.push_back(0); //15
		SiSymmetricFormFactor.push_back(0); //16
	}
	if (SiAsymmetricFormFactor.size() == 0) {
		SiAsymmetricFormFactor.push_back(0); //0
		SiAsymmetricFormFactor.push_back(0); //1
		SiAsymmetricFormFactor.push_back(0); //2
		SiAsymmetricFormFactor.push_back(0); //3
		SiAsymmetricFormFactor.push_back(0); //4
		SiAsymmetricFormFactor.push_back(0); //5
		SiAsymmetricFormFactor.push_back(0); //6
		SiAsymmetricFormFactor.push_back(0); //7
		SiAsymmetricFormFactor.push_back(0); //8
		SiAsymmetricFormFactor.push_back(0); //9
		SiAsymmetricFormFactor.push_back(0); //10
		SiAsymmetricFormFactor.push_back(0); //11
		SiAsymmetricFormFactor.push_back(0); //12
		SiAsymmetricFormFactor.push_back(0); //13
		SiAsymmetricFormFactor.push_back(0); //14
		SiAsymmetricFormFactor.push_back(0); //15
		SiAsymmetricFormFactor.push_back(0); //16
	}
	if (GeSymmetricFormFactor.size() == 0) {
		GeSymmetricFormFactor.push_back(0); //0
		GeSymmetricFormFactor.push_back(0); //1
		GeSymmetricFormFactor.push_back(0); //2
		GeSymmetricFormFactor.push_back(-0.242104); //3
		GeSymmetricFormFactor.push_back(0); //4
		GeSymmetricFormFactor.push_back(0); //5
		GeSymmetricFormFactor.push_back(0); //6
		GeSymmetricFormFactor.push_back(0); //7
		GeSymmetricFormFactor.push_back(0.022025); //8
		GeSymmetricFormFactor.push_back(0); //9
		GeSymmetricFormFactor.push_back(0); //10
		GeSymmetricFormFactor.push_back(0.090647); //11
		GeSymmetricFormFactor.push_back(0.057899); //12
		GeSymmetricFormFactor.push_back(0); //13
		GeSymmetricFormFactor.push_back(0); //14
		GeSymmetricFormFactor.push_back(0); //15
		GeSymmetricFormFactor.push_back(0.000244); //16
	}
	if (GeSymmetricFormFactor1.size() == 0) {
		GeSymmetricFormFactor1.push_back(0); //0
		GeSymmetricFormFactor1.push_back(0); //1
		GeSymmetricFormFactor1.push_back(0); //2
		GeSymmetricFormFactor1.push_back(-0.244022); //3
		GeSymmetricFormFactor1.push_back(0); //4
		GeSymmetricFormFactor1.push_back(0); //5
		GeSymmetricFormFactor1.push_back(0); //6
		GeSymmetricFormFactor1.push_back(0); //7
		GeSymmetricFormFactor1.push_back(0.022923); //8
		GeSymmetricFormFactor1.push_back(0); //9
		GeSymmetricFormFactor1.push_back(0); //10
		GeSymmetricFormFactor1.push_back(0.084844); //11
		GeSymmetricFormFactor1.push_back(0.068438); //12
		GeSymmetricFormFactor1.push_back(0); //13
		GeSymmetricFormFactor1.push_back(0); //14
		GeSymmetricFormFactor1.push_back(0); //15
		GeSymmetricFormFactor1.push_back(0.000230); //16
	}
	if (GeSymmetricFormFactor2.size() == 0) {
		GeSymmetricFormFactor2.push_back(0); //0
		GeSymmetricFormFactor2.push_back(0); //1
		GeSymmetricFormFactor2.push_back(0); //2
		GeSymmetricFormFactor2.push_back(-0.244138); //3
		GeSymmetricFormFactor2.push_back(0); //4
		GeSymmetricFormFactor2.push_back(0); //5
		GeSymmetricFormFactor2.push_back(0); //6
		GeSymmetricFormFactor2.push_back(0); //7
		GeSymmetricFormFactor2.push_back(0.022801); //8
		GeSymmetricFormFactor2.push_back(0); //9
		GeSymmetricFormFactor2.push_back(0); //10
		GeSymmetricFormFactor2.push_back(0.085128); //11
		GeSymmetricFormFactor2.push_back(0.066650); //12
		GeSymmetricFormFactor2.push_back(0); //13
		GeSymmetricFormFactor2.push_back(0); //14
		GeSymmetricFormFactor2.push_back(0); //15
		GeSymmetricFormFactor2.push_back(0); //16
	}
	if (GeSymmetricFormFactor3.size() == 0) {
		GeSymmetricFormFactor3.push_back(0); //0
		GeSymmetricFormFactor3.push_back(0); //1
		GeSymmetricFormFactor3.push_back(0); //2
		GeSymmetricFormFactor3.push_back(-0.250481); //3
		GeSymmetricFormFactor3.push_back(0); //4
		GeSymmetricFormFactor3.push_back(0); //5
		GeSymmetricFormFactor3.push_back(0); //6
		GeSymmetricFormFactor3.push_back(0); //7
		GeSymmetricFormFactor3.push_back(0.000000); //8
		GeSymmetricFormFactor3.push_back(0); //9
		GeSymmetricFormFactor3.push_back(0); //10
		GeSymmetricFormFactor3.push_back(0.077142); //11
		GeSymmetricFormFactor3.push_back(0.053759); //12
		GeSymmetricFormFactor3.push_back(0); //13
		GeSymmetricFormFactor3.push_back(0); //14
		GeSymmetricFormFactor3.push_back(0); //15
		GeSymmetricFormFactor3.push_back(0); //16
	}
	if (GeSymmetricFormFactor4.size() == 0) {
		GeSymmetricFormFactor4.push_back(0); //0
		GeSymmetricFormFactor4.push_back(0); //1
		GeSymmetricFormFactor4.push_back(0); //2
		GeSymmetricFormFactor4.push_back(-0.249321); //3
		GeSymmetricFormFactor4.push_back(0); //4
		GeSymmetricFormFactor4.push_back(0); //5
		GeSymmetricFormFactor4.push_back(0); //6
		GeSymmetricFormFactor4.push_back(0); //7
		GeSymmetricFormFactor4.push_back(0.016849); //8
		GeSymmetricFormFactor4.push_back(0); //9
		GeSymmetricFormFactor4.push_back(0); //10
		GeSymmetricFormFactor4.push_back(0.048291); //11
		GeSymmetricFormFactor4.push_back(0.000000); //12
		GeSymmetricFormFactor4.push_back(0); //13
		GeSymmetricFormFactor4.push_back(0); //14
		GeSymmetricFormFactor4.push_back(0); //15
		GeSymmetricFormFactor4.push_back(0); //16
	}
	if (GeSymmetricFormFactor5.size() == 0) {
		GeSymmetricFormFactor5.push_back(0); //0
		GeSymmetricFormFactor5.push_back(0); //1
		GeSymmetricFormFactor5.push_back(0); //2
		GeSymmetricFormFactor5.push_back(-0.250024); //3
		GeSymmetricFormFactor5.push_back(0); //4
		GeSymmetricFormFactor5.push_back(0); //5
		GeSymmetricFormFactor5.push_back(0); //6
		GeSymmetricFormFactor5.push_back(0); //7
		GeSymmetricFormFactor5.push_back(0.012851); //8
		GeSymmetricFormFactor5.push_back(0); //9
		GeSymmetricFormFactor5.push_back(0); //10
		GeSymmetricFormFactor5.push_back(0.000000); //11
		GeSymmetricFormFactor5.push_back(0.080324); //12
		GeSymmetricFormFactor5.push_back(0); //13
		GeSymmetricFormFactor5.push_back(0); //14
		GeSymmetricFormFactor5.push_back(0); //15
		GeSymmetricFormFactor5.push_back(0); //16
	}
	if (GeSymmetricFormFactor6.size() == 0) {
		GeSymmetricFormFactor6.push_back(0); //0
		GeSymmetricFormFactor6.push_back(0); //1
		GeSymmetricFormFactor6.push_back(0); //2
		GeSymmetricFormFactor6.push_back(-0.267218); //3
		GeSymmetricFormFactor6.push_back(0); //4
		GeSymmetricFormFactor6.push_back(0); //5
		GeSymmetricFormFactor6.push_back(0); //6
		GeSymmetricFormFactor6.push_back(0); //7
		GeSymmetricFormFactor6.push_back(0.000000); //8
		GeSymmetricFormFactor6.push_back(0); //9
		GeSymmetricFormFactor6.push_back(0); //10
		GeSymmetricFormFactor6.push_back(0.099345); //11
		GeSymmetricFormFactor6.push_back(0.000000); //12
		GeSymmetricFormFactor6.push_back(0); //13
		GeSymmetricFormFactor6.push_back(0); //14
		GeSymmetricFormFactor6.push_back(0); //15
		GeSymmetricFormFactor6.push_back(0); //16
	}
}

std::vector<Vector<data_t>  > generateReciprocalVectors(data_t a, int maximumCoef, int minimumCoef) {
	std::vector<Vector<data_t> > result;
	data_t reciprocalMul = 2 * M_PI / a;
	for (int n1 = -maximumCoef; n1 <= maximumCoef; ++n1) {
		for (int n2 = -maximumCoef; n2 <= maximumCoef; ++n2) {
			for (int n3 = -maximumCoef; n3 <= maximumCoef; ++n3) {
				int coef = n1 * n1 + n2 * n2 + n3 * n3;
				if (n1 % 2 == n2 % 2 && n1 % 2 == n3 % 2 && coef <= maximumCoef && minimumCoef <= coef) {
					Vector<data_t> resVector(3);
					resVector.setValue(0, reciprocalMul * n1);
					resVector.setValue(1, reciprocalMul * n2);
					resVector.setValue(2, reciprocalMul * n3);
					result.push_back(resVector);
				}
			}
		}
	}
	return result;
}

std::vector<Vector<data_t> > generateReciprocalVectorsSimple(data_t a) {
	std::vector<Vector<data_t> > result;
	data_t reciprocalMul = 2 * M_PI / a;
	Vector<data_t> g1(3);
	Vector<data_t> g2(3);
	Vector<data_t> g3(3);
	g1.setValue(0, reciprocalMul);
	g1.setValue(1, reciprocalMul);
	g1.setValue(2, 0);
	g2.setValue(0, -reciprocalMul);
	g2.setValue(1, reciprocalMul);
	g2.setValue(2, 0);
	g3.setValue(0, 0);
	g3.setValue(1, 0);
	g3.setValue(2, reciprocalMul);
	result.push_back(g1);
	result.push_back(g2);
	result.push_back(g3);
	return result;
}

data_t calculateCoef(Vector<data_t> const & arg, data_t a) {
	data_t a0 = arg.getValue(0) / (2 * M_PI / a);
	data_t a1 = arg.getValue(1) / (2 * M_PI / a);
	data_t a2 = arg.getValue(2) / (2 * M_PI / a);
	return (a0 * a0 + a1 * a1 + a2 * a2);
}

void testPseudoPotential(data_t a, data_t mass, data_t step, data_t start, int count, std::ostream& log) {
	YuPotential GaAsPotential(GaAsAsymmetricFormFactors, GaAsSymmetricFormFactors, 11, a);
	YuPotential AlAsPotential(AlAsAsymmetricFormFactors, AlAsSymmetricFormFactors, 11, a);
	YuPotential SiPotential(SiAsymmetricFormFactor, SiSymmetricFormFactor, 11, a);
	YuPotential GePotential(SiAsymmetricFormFactor, GeSymmetricFormFactor, 16, a);
	YuPotential GePotential1(SiAsymmetricFormFactor, GeSymmetricFormFactor1, 16, a);
	YuPotential GePotential2(SiAsymmetricFormFactor, GeSymmetricFormFactor2, 16, a);
	YuPotential GePotential3(SiAsymmetricFormFactor, GeSymmetricFormFactor3, 16, a);
	YuPotential GePotential4(SiAsymmetricFormFactor, GeSymmetricFormFactor4, 16, a);
	YuPotential GePotential5(SiAsymmetricFormFactor, GeSymmetricFormFactor5, 16, a);
	YuPotential GePotential6(SiAsymmetricFormFactor, GeSymmetricFormFactor6, 16, a);
	log << "potentials:" << std::endl;
	log << "GaAs" << std::endl;
	logPseudoPotential(GaAsPotential, log, start, step, count);
	log << "AlAs" << std::endl;
	logPseudoPotential(AlAsPotential, log, start, step, count);
	log << "Si" << std::endl;
	logPseudoPotential(SiPotential, log, start, step, count);
	log << "Ge" << std::endl;
	logPseudoPotential(GePotential, log, start, step, count);
	log << "Ge1" << std::endl;
	logPseudoPotential(GePotential1, log, start, step, count);
	log << "Ge2" << std::endl;
	logPseudoPotential(GePotential2, log, start, step, count);
	log << "Ge3" << std::endl;
	logPseudoPotential(GePotential3, log, start, step, count);
	log << "Ge4" << std::endl;
	logPseudoPotential(GePotential4, log, start, step, count);
	log << "Ge5" << std::endl;
	logPseudoPotential(GePotential5, log, start, step, count);
	log << "Ge6" << std::endl;
	logPseudoPotential(GePotential6, log, start, step, count);
	log.flush();
}

void logPseudoPotential(PotentialFunction& potential, std::ostream& log, data_t start, data_t step, int stepCount) {
	for (int i = 0; i < stepCount; ++i) {
		log << (start + i * step) << " " << potential.at(start + i * step) << std::endl;
	}
	log.flush();
}

void logPseudoPotential(PotentialFunction& potential, std::string& logStreamName, data_t start, data_t step, int stepCount) {
	std::fstream logStream(logStreamName, std::fstream::out);
	logPseudoPotential(potential, logStream, start, step, stepCount);
	logStream.close();
}

void printPotentialValues(data_t nearWhere, PotentialFunction& potential, data_t step, data_t stepCount) {
	for (int stepNum = 0; stepNum < stepCount; stepNum++) {
		std::cout << nearWhere << "+" << stepNum * step << " " << potential.at(nearWhere + stepNum * step) << std::endl;
	}
}