/*
 * PotentialFunction.cpp
 *
 *  Created on: 03.04.2013
 *      Author: 
 */

#include "LinPotential.h"
#include "..\common\Complex.h"

data_t LinPotential::at(data_t z) const {
	Complex<data_t> result = 0;
	data_t x = 0;
	data_t y = 0;

	Vector<data_t> coordVector(3);
	coordVector.setValue(0, x);
	coordVector.setValue(1, y);
	coordVector.setValue(2, z);

	for (size_t position = 0; position < reciprocalLattice.size(); ++position) {
		Complex<data_t> buf = 0;
		std::vector<data_t>* formFactor = formFactors.at(position);
		std::vector<data_t>* structureFactor = structFactors.at(position);
		for (size_t atomId = 0; atomId < formFactor->size(); ++atomId) {
			buf += formFactor->at(atomId) * structureFactor->at(atomId);
		}
		buf *= (exp(Complex<data_t>::i() * (reciprocalLattice.at(position)).scalarMul(coordVector)));
		result += buf;
	}
	return result.getRe();
}

LinPotential::LinPotential(
		std::vector<std::vector<data_t>*>& _formFactors,
		std::vector<std::vector<data_t>*>& _structFactors,
		std::vector<Vector<data_t> > _reciprocalLattice) :
		formFactors(_formFactors), structFactors(_structFactors), reciprocalLattice(
				_reciprocalLattice){
}