/*
 * KFunction.cpp
 *
 *  Created on: 27.02.2013
 *      Author: 
 */

#include "KFunction.h"
#include <cstdio>

KFunction::KFunction(Function & _potential, data_t _E, data_t _mass) : potential(_potential), E(_E), mulCoef(2 * _mass / plankConst / plankConst) {}

const data_t KFunction::plankConst = 0.000000000000000658211928; //0,000000000000000658211928

data_t KFunction::at(data_t x) {
//	printf("mulCoef=%f, E=%f, pot(%f)=%f, k(%f)=%f\n", mulCoef, E, x, potential.at(x), x, mulCoef * (E - potential.at(x)));
	return mulCoef * (E - potential.at(x));
}
