#include "MTL_LayerData.h"

MTL_LayerData::MTL_LayerData(data_t _thickness, MTL_Matrix& _boundaryConditions, std::vector<complex_t>& _lambdasPlus, std::vector<complex_t>& _lambdasMinus) :
	thickness(_thickness), boundaryConditions(_boundaryConditions), boundaryConditionsReversed(inv(boundaryConditions)), lambdasPlus(_lambdasPlus), lambdasMinus(_lambdasMinus) {};

size_t MTL_LayerData::getPlusLambdaCount() {
	return lambdasPlus.size();
}
size_t MTL_LayerData::getMinusLambdaCount() {
	return lambdasMinus.size();
}
std::vector<complex_t>& MTL_LayerData::getPlusLambda() {
	return lambdasPlus;
}
std::vector<complex_t>& MTL_LayerData::getMinusLambda() {
	return lambdasMinus;
}
data_t MTL_LayerData::getThickness() {
	return thickness;
}

MTL_Matrix& MTL_LayerData::getBoundaryConditions() {
	return boundaryConditions;
}
MTL_Matrix& MTL_LayerData::getBoundaryConditionsReversed() {
	return boundaryConditionsReversed;
}
