/*
 * LayerData.h
 *
 *  Created on: 25.03.2013
 *      Author: 
 */

#ifndef LAYERDATA_H_
#define LAYERDATA_H_

#include "../common/types.h"
#include "../Matrix/Matrix.h"
#include <vector>

class LayerData {
public:
	LayerData(data_t _thickness, Matrix<complex_t>& _boundaryConditions, std::vector<complex_t>& _lambdasPlus, std::vector<complex_t>& _lambdasMinus);
	size_t getPlusLambdaCount();
	size_t getMinusLambdaCount();
	std::vector<complex_t>& getPlusLambda();
	std::vector<complex_t>& getMinusLambda();
	Matrix<complex_t>& getBoundaryConditions();
	Matrix<complex_t>& getBoundaryConditionsReversed();
	data_t getThickness();
private:
	/**
	 * Thickness of this layer. (h_p)
	 */
	data_t thickness;
	/**
	 * Boundary conditions in matrix form for borders with neighboring layers.
	 */
	Matrix<complex_t> boundaryConditions;
	/**
	 * BoundaryConditions matrix in reverse. Stored for re-use.
	 */
	Matrix<complex_t> boundaryConditionsReversed;
	//XXX: where do lambdas such that (Re lambda) + (Im lambda) == 0 go?
	/**
	 * Eigen values lamdba such that (Re lambda) + (Im lambda) > 0
	 */
	std::vector<complex_t> lambdasPlus;
	/**
	 * Eigen values lamdba such that (Re lambda) + (Im lambda) < 0
	 */
	std::vector<complex_t> lambdasMinus;
};


#endif /* LAYERDATA_H_ */
