/*
 * LayerData.cpp
 *
 *  Created on: 25.03.2013
 *      Author: 
 */

#include "LayerData.h"

LayerData::LayerData(data_t _thickness, Matrix<complex_t>& _boundaryConditions, std::vector<complex_t>& _lambdasPlus, std::vector<complex_t>& _lambdasMinus) :
	thickness(_thickness), boundaryConditions(_boundaryConditions), boundaryConditionsReversed(boundaryConditions.inverse()), lambdasPlus(_lambdasPlus), lambdasMinus(_lambdasMinus) {};

size_t LayerData::getPlusLambdaCount() {
	return lambdasPlus.size();
}
size_t LayerData::getMinusLambdaCount() {
	return lambdasMinus.size();
}
std::vector<complex_t>& LayerData::getPlusLambda() {
	return lambdasPlus;
}
std::vector<complex_t>& LayerData::getMinusLambda() {
	return lambdasMinus;
}
data_t LayerData::getThickness() {
	return thickness;
}
//std::vector<data_t>::iterator LayerData::getPlusLambdaIterator() {
//	return lambdasPlus.begin();
//}
//std::vector<data_t>::iterator LayerData::getMinusLambdaIterator() {
//	return lambdasMinus.begin();
//}
//std::vector<data_t>::iterator LayerData::getPlusLambdaEnd() {
//	return lambdasPlus.end();
//}
//std::vector<data_t>::iterator LayerData::getMinusLambdaEnd() {
//	return lambdasMinus.end();
//}
Matrix<complex_t>& LayerData::getBoundaryConditions() {
	return boundaryConditions;
}
Matrix<complex_t>& LayerData::getBoundaryConditionsReversed() {
	return boundaryConditionsReversed;
}
