#ifndef YU_POTENTIAL_H
#define YU_POTENTIAL_H

#include "PotentialFunction.h"

class YuPotential : public PotentialFunction {
public:
	data_t at(data_t z);
	void addConst(data_t constModifier);
	YuPotential(std::vector<data_t> const & _asymmetricPot, std::vector<data_t> const & _symmetricPot, size_t _maxCoef, data_t a);
private:
	std::vector<data_t> asymmetricPotMultiplied;
	std::vector<data_t> symmetricPotMultiplied;
	std::vector<Vector<data_t> > reciprocalLattice;
	size_t maxCoef;
	data_t additionalConst;
};

#endif //YU_POTENTIAL_H