#include "TestPotentials.h"
#include "math.h"

data_t ConstPotential::at(data_t z) {
	return value;
}

ConstPotential::ConstPotential(data_t _value) : value(_value) {}

bool ConstPotential::isValid(data_t energy, data_t start, data_t end) {
	return true;
}

bool ConstPotential::isValid(data_t energy, data_t points) {
	return true;
}

data_t LamellarPotential::at(data_t z) {
	if (z >= start && z <= end) {
		return centerValue;
	} else {
		return sideValue;
	}
}

LamellarPotential::LamellarPotential(data_t _centerValue, data_t _sideValue, data_t _start, data_t _end) : centerValue(_centerValue), sideValue(_sideValue), start(_start), end(_end){}

SmoothedLamellarPotential::SmoothedLamellarPotential(data_t _centerValue, data_t _sideValue, data_t _start, data_t _end, data_t _smoothWidth) : centerValue(_centerValue), sideValue(_sideValue), start(_start), end(_end), smoothWidth(_smoothWidth) {}

data_t SmoothedLamellarPotential::at(data_t z) {
	if (z >= start + smoothWidth && z <= end - smoothWidth) {
		return centerValue;
	} else if (z >= start - smoothWidth && z <= start + smoothWidth){
		return (1 - sin(M_PI * (z - start) / smoothWidth / 2)) * (sideValue - centerValue) / 2 + centerValue;
	} else if (z >= end - smoothWidth && z <= end + smoothWidth) {
		return (1 + sin(M_PI * (z - end) / smoothWidth / 2)) * (sideValue - centerValue) / 2 + centerValue;
	} else {
		return sideValue;
	}
}

data_t SinePotential::at(data_t z) {
	return sin(z);
}