/*
 * ShootingStationarySchrodingerSolver.h
 *
 *  Created on: 16.02.2013
 *      Author: 
 */

#ifndef SHOOTINGSTATIONARYSCHRODINGERSOLVER_H_
#define SHOOTINGSTATIONARYSCHRODINGERSOLVER_H_

//#include "StationarySchrodingeSolver.h"
#include "../utilSolvers/RootSolver.h"
#include "SchrodingerBoundaryConditionGenerator.h"
#include <iostream>
#include <string>
#include <fstream>

class ShootingStationarySchrodingerSolver {
public:
	void solve(PotentialFunction & potential, SchrodingerShootingBoundaryConditionGenerator & startCond, SchrodingerShootingBoundaryConditionGenerator & endCond, data_t energyMin, data_t energyMax, data_t energyPrecision, data_t omegaPrecision, data_t energyStep, data_t* eigenValues, int eigenValuesNum, data_t mass, data_t startValue, data_t endValue, data_t xMin, data_t xStep, data_t expandingMultiplier, std::string& phiPlusLogName, std::string& phiMinusLogName);
	void solveQuasiClassic(PotentialFunction & potential, data_t energyMin, data_t energyMax, data_t energyPrecision, data_t energySearchPrecision, data_t energyStep, data_t* eigenValues, int eigenValuesNum, data_t mass, data_t xMin, data_t xStep);
	ShootingStationarySchrodingerSolver(RootSolver& _rootSolver, data_t _cauchyPrecision, std::ostream& _logStream);
	void setCauchyPrecision(data_t _cauchyPrecision);
	static data_t getBastardDerivative();
private:
	RootSolver& rootSolver;
	data_t cauchyPrecision; //TODO: find out what values are to be used
	std::ostream& logStream;
	void logPhi(std::string& phiPlusLogName, std::string& phiMinusLogName, std::vector<data_t>& phiPlusX, std::vector<data_t>& phiMinusX, std::vector<data_t>& phiPlusY, std::vector<data_t>& phiMinusY, data_t energy);
};


#endif /* SHOOTINGSTATIONARYSCHRODINGERSOLVER_H_ */
