#ifndef POTENTIAL_FUNCTION_H
#define POTENTIAL_FUNCTION_H

#include "PotentialFunction.h"

void PotentialFunction::setKParallel(data_t k) {
	kParallel = k;
}

PotentialFunction::PotentialFunction() : kParallel(0) {}

/**
By default, use quasi-classic conditions.
*/
bool PotentialFunction::isValid(data_t energy, data_t start, data_t end) {
	return (at(start) >= energy) && (at(end) >= energy);
}

bool PotentialFunction::isValid(data_t energy, data_t point) {
	return at(point) >= energy;
}

#endif //POTENTIAL_FUNCTION_H