/*
 * OmegaFunction.cpp
 *
 *  Created on: 20.02.2013
 *      Author: 
 */

#include "OmegaFunction.h"
#include "../utilSolvers/NumerovCauchySolver.h"
#include "math.h"
#include "../common/Utils.h"
#include "KFunction.h"
#include <iostream>
#include <sstream>
#include <fstream>

OmegaFunction::OmegaFunction(PotentialFunction & newPot, data_t newXMin, data_t newXStep, int newPointsCount, data_t newMass, data_t _startValue, data_t _endValue, SchrodingerShootingBoundaryConditionGenerator & _startBoundaryGenerator, SchrodingerShootingBoundaryConditionGenerator & _endBoundaryGenerator, std::vector<data_t>& _phiPlusX,std::vector<data_t>& _phiMinusX, std::vector<data_t>& _phiPlusY,std::vector<data_t>& _phiMinusY) :
potential(newPot), xMin(newXMin), xStep(newXStep), pointsCount(newPointsCount), mass(newMass), startValue(_startValue), endValue(_endValue), startBoundaryGenerator(_startBoundaryGenerator), endBoundaryGenerator(_endBoundaryGenerator), phiPlusX(_phiPlusX), phiMinusX(_phiMinusX), phiPlusY(_phiPlusY), phiMinusY(_phiMinusY) {}

data_t OmegaFunction::at(data_t E) {
	data_t xPlus = xMin + E * xStep;
	data_t xMinus = -xMin - E * xStep;
	data_t startH = xMin * 2 / pointsCount;
	int curPointsCount = (int) ((xPlus - xMinus) / startH);
	data_t* xMinusArr = new data_t[curPointsCount + 1];
	data_t* xPlusArr = new data_t[curPointsCount + 1];
	data_t h = (xPlus - xMinus) / (curPointsCount * 2 - 1);
	xMinusArr[0] = xMinus;
	xPlusArr[0] = xPlus;
	for (int i = 1; i < curPointsCount + 1; ++i) {
		xMinusArr[i] = xMinusArr[i-1] + h;
		xPlusArr[i] = xPlusArr[i-1] - h;
	}
	data_t* yPlus = new data_t[curPointsCount + 1];
	data_t* yMinus = new data_t[curPointsCount + 1];
	NumerovCauchySolver cauchySolver;
	KFunction k(potential, E, mass);
	//	Function const& k = 2 * mass / (plankConst) * (E - potential); //TODO: init k here
	data_t startValueDerivative = startBoundaryGenerator.getDerivative(xMinus, startValue, E, potential);
	data_t endValueDerivative = endBoundaryGenerator.getDerivative(xPlus, endValue, E, potential);
	printf("xMinus=%10.10f xPlus=%10.10f E=%10.10f values: start=%10.10f end=%10.10f, derivative: start=%10.10f end=%10.10f\n", xMinus, xPlus, E, startValue, endValue, startValueDerivative, endValueDerivative);
	cauchySolver.solve(curPointsCount + 1, xMinusArr, yMinus, k, startValue, startValueDerivative);
	cauchySolver.solve(curPointsCount + 1, xPlusArr, yPlus, k, endValue, endValueDerivative);
	data_t minusDerivative = getDerivative(yMinus[curPointsCount], yMinus[curPointsCount - 2], h);
	data_t plusDerivative = getDerivative(yPlus[curPointsCount - 2], yPlus[curPointsCount], h);
	data_t minusValue = yMinus[curPointsCount - 1];
	data_t plusValue = yPlus[curPointsCount - 1];
	data_t result = minusDerivative * plusValue - plusDerivative * minusValue;
	std::cout << "Now logging wave function data with omega = " << result << std::endl;
	phiPlusX.clear();
	phiPlusY.clear();
	phiMinusX.clear();
	phiMinusY.clear();
	for (int i = 0; i < curPointsCount; ++i) {
		phiMinusX.push_back(xMinusArr[i]);
		phiMinusY.push_back(yMinus[i]);
		phiPlusX.push_back(xPlusArr[i]);
		phiPlusY.push_back(yPlus[i]);
	}
	std::cout << "Wave function data logging finished" << result << std::endl;
	delete [] xMinusArr;
	delete [] xPlusArr;
	//if (curPointsCount )
	delete [] yPlus;
	delete [] yMinus;
	printf("minusVal = %10.10f, plusVal = %10.10f, minusDerivative = %10.10f, plusDerivative = %10.10f\n", minusValue, plusValue, minusDerivative, plusDerivative);
//	getchar();
	return result;
}

std::vector<data_t>& OmegaFunction::getPhiPlusX() {
	return phiPlusX;
}
std::vector<data_t>& OmegaFunction::getPhiPlusY() {
	return phiPlusY;
}
std::vector<data_t>& OmegaFunction::getPhiMinusX() {
	return phiMinusX;
}
std::vector<data_t>& OmegaFunction::getPhiMinusY() {
	return phiMinusY;
}