#ifndef LAYERDATA_H_
#define LAYERDATA_H_

#include "../common/types.h"
#include "../Matrix/MTL_Matrix.h"
#include <vector>

class MTL_LayerData {
public:
	MTL_LayerData(data_t _thickness, R_Matrix& _boundaryConditions, std::vector<complex_t>& _lambdasPlus, std::vector<complex_t>& _lambdasMinus);
	size_t getPlusLambdaCount();
	size_t getMinusLambdaCount();
	std::vector<complex_t>& getPlusLambda();
	std::vector<complex_t>& getMinusLambda();
	R_Matrix& getBoundaryConditions();
	R_Matrix& getBoundaryConditionsReversed();
	data_t getThickness();
private:
	/**
	 * Thickness of this layer. (h_p)
	 */
	data_t thickness;
	/**
	 * Boundary conditions in matrix form for borders with neighboring layers.
	 */
	R_Matrix boundaryConditions;
	/**
	 * BoundaryConditions matrix in reverse. Stored for re-use.
	 */
	R_Matrix boundaryConditionsReversed;
	//XXX: where do lambdas such that (Re lambda) + (Im lambda) == 0 go?
	/**
	 * Eigen values lamdba such that (Re lambda) + (Im lambda) > 0
	 */
	std::vector<complex_t> lambdasPlus;
	/**
	 * Eigen values lamdba such that (Re lambda) + (Im lambda) < 0
	 */
	std::vector<complex_t> lambdasMinus;
};


#endif /* LAYERDATA_H_ */
