/*
* BrendtRootSolver.cpp
 *
 *  Created on: 16.02.2013
 *      Author: 
 */

#include "BrendtRootSolver.h"
#include <list>
#include <iostream>
#include <cmath>
#include <cstdio>

data_t BrendtRootSolver::solveLocalized(Function & f, data_t rootPrecision,
		data_t a, data_t b, data_t yA, data_t yB) {
	//check whether ends are roots
	if (abs(yA) <= rootPrecision) {
		printf("s = %f, f(s) = %10.10f\n", a, yA);
		return a;
	}
	if (abs(yB) <= rootPrecision) {
		printf("s = %f\n, f(s) = %10.10f\n", b, yB);
		return b;
	}
	if (abs(yB) > abs(yA)) {
		data_t buf = a;
		a = b;
		b = buf;
		buf = yA;
		yA = yB;
		yB = buf;
	}
	data_t c = a;
	data_t yC = yA;
	data_t s = a;
	data_t yS = yA;
	data_t errorDelta = rootPrecision; //TODO: find a meaningful value
	data_t d = a;
	bool bisectionFlag = true;
//	while (abs(yS) > rootPrecision) {		//precision on value
	while (abs(a - b) > rootPrecision) {	//precision on interval
		if (yA != yC && yB != yC) {
			s = a * yB * yC / (yA - yB) / (yA - yC)
					+ b * yA * yC / (yB - yA) / (yB - yC)
					+ c * yA * yB / (yC - yA) / (yC - yB);
		} else {
			s = b - yB * (b - a) / (yB - yA);
		}
		data_t buf = (3 * a + b) / 4;
		if ((!((s < b && buf < s) || (s < buf && b < s)))
				|| (bisectionFlag && (abs(s - b) >= (abs(b - c) / 2)))
				|| (!bisectionFlag && (abs(s - b) >= abs(c - d) / 2))
				|| (bisectionFlag && (abs(b - c) < errorDelta))
				|| (!bisectionFlag && (abs(c - d) < errorDelta))) {
			s = (a + b) / 2;
			bisectionFlag = true;
		} else {
			bisectionFlag = false;
		}
		yS = f.at(s);
		d = c;
		c = b;
		yC = yB;
		if (yA * yS < 0) {
			b = s;
			yB = yS;
		} else {
			a = s;
			yA = yS;
		}
		if (abs(yB) > abs(yA)) {
			data_t buf = a;
			a = b;
			b = buf;
			buf = yA;
			yA = yB;
			yB = buf;
		}
	}
//	printf("a = %f, f(a) = %10.10f\n", a, f.at(a));
//	printf("b = %f, f(b) = %10.10f\n", b, f.at(b));
//	printf("s = %f, f(s) = %10.10f\n", s, f.at(s));
//	getchar();
	return s;
}
