#include "SchrodingerTests.h"
#include "../utilSolvers/BrendtRootSolver.h"
#include "../Schrodinger/KFunction.h"
#include "../Schrodinger/ShootingStationarySchrodingerSolver.h"
#include "../test/TestFunctions.h"
#include "math.h"
#include "../Schrodinger/TestPotentials.h"

void testSchrodinger(data_t energyMin, std::ostream & logStream, std::ostream & energyStream, PotentialFunction & potential, std::string phiPlusStreamBase,
	std::string phiMinusStreamBase, data_t startX, data_t xStep, data_t expandMultiplier, data_t energyPrecision, data_t omegaPrecision, data_t cauchyPrecision, data_t energyStep,
	data_t startValue, SchrodingerShootingBoundaryConditionGenerator& startConditionGenerator, SchrodingerShootingBoundaryConditionGenerator& endConditionGenerator, int eigenValuesCount) {
	logStream << "Schrodinger tests:\n" << std::endl;
	BrendtRootSolver rootSolver;
	ShootingStationarySchrodingerSolver shootingSolver(rootSolver,
			cauchyPrecision, std::cout);
	ConstFun hundredPot(10);
	data_t* eigenValues = new data_t[eigenValuesCount];
	data_t electronMass = 9.10938188 * 0.0000000000000000000000000000001;
	data_t endValue = startValue;
	shootingSolver.solve(potential, startConditionGenerator, endConditionGenerator, energyMin, 1000, energyPrecision, omegaPrecision, energyStep, eigenValues, eigenValuesCount, electronMass, startValue, endValue, startX, xStep, expandMultiplier, phiPlusStreamBase, phiMinusStreamBase);
	for (int i = 0; i < eigenValuesCount; ++i) {
		printf("%10.10f |-> %10.10f\n", eigenValues[i],
				KFunction::plankConst * KFunction::plankConst
						/ (2 * electronMass) * ((i + 1) * M_PI / 2)
						* ((i + 1) * M_PI / 2));
	}
	delete[] eigenValues;
}

void testInfiniteWalls(data_t a, std::ostream& logStream, data_t mass) {
	data_t startPoint = -a / 2;
	data_t endPoint = a / 2;
	data_t leftDerivativeValue = -1;
	data_t rightDerivativeValue = 1;
	BrendtRootSolver rootSolver;
	data_t cauchyPrecision = a / 10000;
	ShootingStationarySchrodingerSolver solver(rootSolver, cauchyPrecision, logStream);
	ConstPotential potential(0);
	ConstShootingSchrodingerGenerator leftGenerator(leftDerivativeValue);
	ConstShootingSchrodingerGenerator rightGenerator(rightDerivativeValue);
	const int eigenValuesNum = 4;
	data_t eigenValues[eigenValuesNum];
	solver.solve(potential, leftGenerator, rightGenerator, -1, 1000000, cauchyPrecision / 100, cauchyPrecision / 100000, 0.001, eigenValues, eigenValuesNum, mass, 0, 0, a / 2, 0, 0, std::string("InfiniteWallsPlus"), std::string("InfiniteWallsMinus"));
	for (int nu = 0; nu < eigenValuesNum; ++nu) {
		logStream << eigenValues[nu] << "<->" << ((KFunction::plankConst * KFunction::plankConst) / 2 / mass * ((nu+1) * M_PI / a) * ((nu+1) * M_PI / a)) <<std::endl;
	}
}

void testFiniteWalls(data_t a, std::ostream& logStream, data_t mass, data_t potentialValue) {
	data_t startPoint = -a / 2;
	data_t endPoint = a / 2;
	data_t leftValue = pow(10.0, -5.0);
	data_t rightValue = pow(10.0, -5.0);
	data_t actualInfinity = 10;
	BrendtRootSolver rootSolver;
	data_t cauchyPrecision = a / 10000;
	ShootingStationarySchrodingerSolver solver(rootSolver, cauchyPrecision, logStream);
	LamellarPotential potential(0, potentialValue, startPoint, endPoint);
	ShootingSchrodingerEndGenerator rightGenerator;
	ShootingSchrodingerStartGenerator leftGenerator;
	const int eigenValuesNum = 4;
	data_t eigenValues[eigenValuesNum];
	solver.solve(potential, leftGenerator, rightGenerator, -1, 1000000, cauchyPrecision / 1000, cauchyPrecision / 100000, 0.001, eigenValues, eigenValuesNum, mass, leftValue, rightValue, actualInfinity, 0, 0, std::string("finiteWallsPhiPlus"), std::string("finiteWallsPhiMinus"));
	data_t morePrecisePi = 3.14159265358979323846264338327950288419716939937510;
	for (int nu = 0; nu < eigenValuesNum; ++nu) {
		logStream << eigenValues[nu] << "<->" << ((KFunction::plankConst * KFunction::plankConst) / 2 / mass * ((nu+1) * M_PI / a) * ((nu+1) * morePrecisePi / a)) <<std::endl;
	}
}

void testSmoothLamellar(data_t a, std::ostream& logStream, data_t mass, data_t potentialValue, data_t epsilon) {
	data_t startPoint = -a / 2;
	data_t endPoint = a / 2;
	data_t leftValue = pow(10.0, -5.0);
	data_t rightValue = pow(10.0, -5.0);
	data_t actualInfinity = 10;
	BrendtRootSolver rootSolver;
	data_t cauchyPrecision = a / 10000;
	ShootingStationarySchrodingerSolver solver(rootSolver, cauchyPrecision, logStream);
	SmoothedLamellarPotential potential(0, potentialValue, startPoint, endPoint, epsilon);
	ShootingSchrodingerEndGenerator rightGenerator;
	ShootingSchrodingerStartGenerator leftGenerator;
	const int eigenValuesNum = 4;
	data_t eigenValues[eigenValuesNum];
	solver.solve(potential, leftGenerator, rightGenerator, -1, 1000000, cauchyPrecision / 100, cauchyPrecision / 100000, 0.001, eigenValues, eigenValuesNum, mass, leftValue, rightValue, actualInfinity, 0, 0, std::string("smoothedLamellarPlusVerySmallEpsilon"), std::string("smoothedLamellarMinusVerySmallEpsilon"));
	for (int nu = 0; nu < eigenValuesNum; ++nu) {
		logStream << eigenValues[nu] << "<->" << ((KFunction::plankConst * KFunction::plankConst) / 2 / mass * ((nu+1) * M_PI / a) * ((nu+1) * M_PI / a)) <<std::endl;
	}
}

void testSmoothLamellarPotential() {
	std::fstream lamellarStream1("lamellar1", std::fstream::out);
	std::fstream lamellarStream2("lamellar2", std::fstream::out);
	std::fstream lamellarStream3("lamellar3", std::fstream::out);
	data_t potentialInfinity = 10;
	data_t a = 10;
	data_t epsilon1 = 1;
	data_t epsilon2 = 0.5;
	data_t epsilon3 = 2;
	SmoothedLamellarPotential pot1(1, 3, -a / 2, a / 2, epsilon1);
	SmoothedLamellarPotential pot2(1, 3, -a / 2, a / 2, epsilon2);
	SmoothedLamellarPotential pot3(0, -2, -a / 2, a / 2, epsilon3);
	data_t step = 0.001;
	for (data_t x = -potentialInfinity; x < potentialInfinity; x += step) {
		lamellarStream1 << x << " " << pot1.at(x) << std::endl;
		lamellarStream2 << x << " " << pot2.at(x) << std::endl;
		lamellarStream3 << x << " " << pot3.at(x) << std::endl;
	}
	lamellarStream1.close();
	lamellarStream2.close();
	lamellarStream3.close();
}
