#include "SMatrixTests.h"
#include "../Matrix/Matrix.h"
#include "../scatter/LayerData.h"
#include "../scatter/ScatterMatrixProducer.h"

void testScatterMatrix() {
	Matrix<complex_t> W0(2,2);
	W0.setData(0,0, 0.8);
	W0.setData(0, 1, 0);
	W0.setData(1, 0, -0.2);
	W0.setData(1, 1, 1);
	Matrix<complex_t> W1 = Matrix<complex_t>::getIdentity(2);
	data_t leftLambda = 1;
	data_t rightLambda = 0.66666666666666666666666666666667;
	std::vector<complex_t> leftPlusLambda;
	std::vector<complex_t> leftMinusLambda;
	std::vector<complex_t> rightPlusLambda;
	std::vector<complex_t> rightMinusLambda;
	leftPlusLambda.push_back(leftLambda);
	leftMinusLambda.push_back(-leftLambda);
	rightPlusLambda.push_back(rightLambda);
	rightMinusLambda.push_back(-rightLambda);
	data_t thickness = 0;
	LayerData leftLayer(thickness, W0, leftPlusLambda, leftMinusLambda);
	LayerData rightLayer(thickness, W1, rightPlusLambda, rightMinusLambda);
	ScatterMatrixProducer producer;
	producer.addLayer(leftLayer);
	producer.addLayer(rightLayer);
	Matrix<complex_t> scatter = producer.calculateScatterMatrix();
	std::cout << scatter << std::endl;
	int x = 3;
}