#ifndef PSEUDOPOTENTIAL_TEST_H
#define PSEUDOPOTENTIAL_TEST_H

#include "../common/types.h"
#include <vector>
#include "../Schrodinger/PotentialFunction.h"
#include <string>
#include <map>

void initFormFactors();
std::vector<Vector<data_t>  > generateReciprocalVectors(data_t a, int maximumCoef, int minimumCoef);
std::vector<Vector<data_t> > generateReciprocalVectorsSimple(data_t a);
data_t calculateCoef(Vector<data_t> const & arg, data_t a);
void testPseudoPotential(data_t a, data_t mass, data_t step, data_t start, int count, std::ostream& log);
void logPseudoPotential(PotentialFunction& potential, std::string& logStreamName, data_t start, data_t step, int stepCount);
void logPseudoPotential(PotentialFunction& potential, std::ostream& log, data_t start, data_t step, int stepCount);
void printPotentialValues(data_t nearWhere, PotentialFunction& potential, data_t step, data_t stepCount);

std::map< std::string, std::vector<data_t> > getSymmetricFormFactors();
std::map< std::string, std::vector<data_t> > getAsymmetricFormFactors();

#endif //PSEUDOPOTENTIAL_TEST_H