#include "YuPotential.h"
#include <math.h>

YuPotential::YuPotential(std::vector<data_t> const & asymmetricPot, std::vector<data_t> const & symmetricPot, size_t _maxCoef, data_t a) : 
maxCoef(_maxCoef), additionalConst(0) {
	data_t reciprocalMul = 2 * M_PI / a;
	Vector<data_t> s(3);
	s.setValue(0, a / 8);
	s.setValue(1, a / 8);
	s.setValue(2, a / 8);
	int maxCoefInt = maxCoef;
	for (int n1 = -maxCoefInt; n1 <= maxCoefInt; ++n1) {
		for (int n2 = -maxCoefInt; n2 <= maxCoefInt; ++n2) {
			for (int n3 = -maxCoefInt; n3 <= maxCoefInt; ++n3) {
				if (n1 % 2 == n2 % 2 && n1 % 2 == n3 % 2 && (n1 * n1 + n2 * n2 + n3 * n3) <= maxCoefInt) {
					Vector<data_t> reciprocalVector(3);
					reciprocalVector.setValue(0, n1 * reciprocalMul);
					reciprocalVector.setValue(1, n2 * reciprocalMul);
					reciprocalVector.setValue(2, n3 * reciprocalMul);
					reciprocalLattice.push_back(reciprocalVector);
					size_t coef = n1 * n1 + n2 * n2 + n3 * n3;
					asymmetricPotMultiplied.push_back(asymmetricPot.at(coef) * sin(s.scalarMul(reciprocalVector)));
					symmetricPotMultiplied.push_back(symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)));
					if (n1 == 1 && n2 == 1 && n3 == 1) {
						std::cout << 0.55 << " " << symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)) << std::endl;
					} else if (n1 == 2 && n2 == 2 && n3 == 0) {
						std::cout << 0.9 << " " << symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)) << std::endl;
					} else if (n1 == 3 && n2 == 1 && n3 == 1) {
						std::cout << 1.06 << " " << symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)) << std::endl;
					} else if (n1 == 2 && n2 == 2 && n3 == 2) {
						std::cout << 1.1 << " " << symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)) << std::endl;
					} else if (n1 == 4 && n2 == 0 && n3 == 0) {
						std::cout << 1.25 << " " << symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)) << std::endl;
					} else if (n1 == 3 && n2 == 1 && n3 == 1) {
						std::cout << 1.4 << " " << symmetricPot.at(coef) * cos(s.scalarMul(reciprocalVector)) << std::endl;
					}
				}
			}
		}
	}
}

void YuPotential::addConst(data_t constModifier) {
	additionalConst = constModifier;
}

data_t YuPotential::at(data_t z) {
	Vector<data_t> growthDirectionVector(3);
	growthDirectionVector.setValue(0, z);
	growthDirectionVector.setValue(1, z);
	growthDirectionVector.setValue(2, z);
	data_t result = 0;
	for (size_t i = 0; i < reciprocalLattice.size(); ++i) {
		Vector<data_t> const & reciprocalVector = reciprocalLattice.at(i);
		result += symmetricPotMultiplied.at(i) * cos(reciprocalVector.scalarMul(growthDirectionVector)) + asymmetricPotMultiplied.at(i) * sin(reciprocalVector.scalarMul(growthDirectionVector));
	}
	return result + additionalConst;
}