#ifndef TEST_POTENTIALS_H
#define TEST_POTENTIALS_H

#include "PotentialFunction.h"

class ConstPotential : public PotentialFunction {
public:
	virtual data_t at(data_t z);
	ConstPotential(data_t _value);
	virtual bool isValid(data_t energy, data_t start, data_t end);
	virtual bool isValid(data_t energy, data_t points);
private:
	data_t value;
};

class LamellarPotential : public PotentialFunction {
public:
	virtual data_t at(data_t z);
	LamellarPotential(data_t _centerValue, data_t _sideValue, data_t _start, data_t _end);
private:
	data_t centerValue;
	data_t sideValue;
	data_t start;
	data_t end;
};

class SmoothedLamellarPotential : public PotentialFunction {
public:
	virtual data_t at(data_t z);
	SmoothedLamellarPotential(data_t _centerValue, data_t _sideValue, data_t _start, data_t _end, data_t _smoothWidth);
private:
	data_t centerValue;
	data_t sideValue;
	data_t start;
	data_t end;
	data_t smoothWidth;
};

class SinePotential : public PotentialFunction {
public:
	virtual data_t at(data_t z);
};

#endif //TEST_POTENTIALS_H