/*
 * NumerovCauchySolver.cpp
 *
 *  Created on: 19.02.2013
 *      Author: 
 */

#include "NumerovCauchySolver.h"
#include <cstdio>

NumerovCauchySolver::NumerovCauchySolver() : log(NULL) {};

void NumerovCauchySolver::setLog(std::ostream* _log) {
	log = _log;
}

/**
 * x[0] < x[nodesCount - 1]
 * h = x[i + 1] - x[i]
 * startValue = psi(x[0])
 * startDerivative = psi'(x[0])
 */
void NumerovCauchySolver::solve(int nodesCount, data_t* x, data_t* y, Function & kFun, data_t startValue, data_t startDerivative) {
	data_t* k = new data_t [nodesCount];
	for (int i = 0; i < nodesCount; ++i) {
		k[i] = kFun.at(x[i]);
	}
	data_t h = x[1] - x[0];
	data_t k_1 = kFun.at(x[0] - h);
	data_t h2 = h * h;
	data_t h3 = h2 * h;
	data_t h4 = h3 * h;
	data_t k1Derivative0 = (k[1] - k_1) / h / 2;
	data_t k2Derivative0 = (k_1 - 2 * k[0] + k[1]) / h2;
	y[0] = startValue;
//	y[1] = startValue * (1 + 7.0 / 12.0 * h2 * k[0] +  7.0 / 24.0 * k_1 * h2 - 3.0 / 8.0 * h2 * k[1] - k[0] * k[0]) +
//			startDerivative * (h - k[0] * h3 / 6 + k_1 * h3 / 24 - k[1] * h3 / 24);
	data_t y2Deivative0 = -k[0] * y[0];
	data_t y3Deivative0 = - k1Derivative0 * y[0] - k[0] * startDerivative;
	data_t y4Derivative0 = -k2Derivative0 * y[0] - 2 * k1Derivative0 * startDerivative - k[0] * y2Deivative0;
	y[1] = y[0] + startDerivative * h + y2Deivative0 * h2 / 2 + y3Deivative0 * h3 / 6 + y4Derivative0 * h4 / 24;
//	printf("CauchySolver\n");
//	printf("k[-1] = %f\n", k_1);
	for (int i = 0; i < nodesCount; ++i) {
//		printf("k[%d] = %f\n", i, k[i]);
	}
//	printf("y[0] = %f\n", y[0]);
//	printf("y[1] = %f\n", y[1]);
	for (int n = 1; n < nodesCount - 1; ++n) {
		y[n+1] = ((2 - 5.0 / 6.0 * h2 * k[n]) * y[n] - (1 + h2 * k[n-1] / 12) * y[n-1]) / (1 + h2 * k[n+1] / 12);
//		printf("y[%d] = %f\n", n+1, y[n+1]);
	}
	if (log != NULL) {
		for (int i = 0; i < nodesCount; i += 10) {
			(*log) << x[i] << " " << y[i] << std::endl;
		}
	}
	delete [] k;
}


