/*
 * main.cpp
 *
 *  Created on: 29.01.2013
 *      Author: 
 */

#include <cstdio>
#include "../Matrix/Matrix.h"
#include <iostream>

//#include "../utilSolvers/BrendtRootSolver.h"
//#include "../utilSolvers/NumerovCauchySolver.h"
//#include "../common/CommonFunctions.h"
#include <iostream>
//#include "TestFunctions.h"
#include <math.h>
//#include "../Schrodinger/ShootingStationarySchrodingerSolver.h"
//#include "../Schrodinger/KFunction.h"
//#include "../Schrodinger/PotentialFunction.h"
#include "../Schrodinger/YuPotential.h"
//#include "../Schrodinger/OmegaFunction.h"
//#include "../Vector/Vector.h"
//#include "../common/Complex.h"
//#include "../Schrodinger/TestPotentials.h"
#include <fstream>
//#include "../scatter/ScatterMatrixProducer.h"
#include "PseudopotentialTest.h"
#include "NumericalTests.h"
#include "SchrodingerTests.h"
#include "SMatrixTests.h"
#include <map>

int main() {
	data_t mass = 9.10938188 * 0.0000000000000000000000000000001; 	//9,10938188e-31
//	data_t a = 0.000000000564;
	//data_t step = 0.00000000001;
	//int stepsCount = 1000;
	std::map<std::string, std::vector<data_t> > symmetricFormFactors = getSymmetricFormFactors();
	std::map<std::string, std::vector<data_t> > asymmetricFormFactors = getAsymmetricFormFactors();
//	testPseudoPotential(a, mass, step, 0, stepsCount);
	
	std::fstream schrodingerStream("schrodingerLog", std::fstream::out);
	std::fstream schrodingerEnergyStream("schrodingerEnergyStream", std::fstream::out);

	//YuPotential GaAsPotential(GaAsAsymmetricFormFactors, GaAsSymmetricFormFactors, 11, a);
	//YuPotential GaAsPotential(GaAsAsymmetricFormFactors, GaAsSymmetricFormFactors, 11, a);
	//GaAsPotential.addConst(1);
	//YuPotential SiPotential(SiAsymmetricFormFactor, SiSymmetricFormFactor, 11, a);
	//SiPotential.addConst(0.5);
	//std::fstream potentialStream("SiStream", std::fstream::out);
	//for (int i = 0; i < stepsCount; ++i) {
	//  potentialStream << (i * step) << " " << SiPotential.at(i * step) << std::endl;
	//  potentialStream.flush();
	//}
	//potentialStream.close();
	data_t startX = 50;
	data_t xStep = 0;
	data_t expandMultiplier = 0;//1.01;
	data_t precision = 0.0001;
	data_t omegaPrecision = pow(10.0f, -40);
	data_t cauchyPrecision = 0.005;
	data_t energyStep = 0.01;
	data_t energyMin = 0;
	data_t startValue = 0;//pow(10.0f, -20);
	data_t startDerivativeValue = pow(10.0f, -20);
	ConstShootingSchrodingerGenerator startBoundaryGenerator(startDerivativeValue);
	ConstShootingSchrodingerGenerator endBoundaryGenerator(-startDerivativeValue);
	//ShootingSchrodingerStartGenerator startBoundaryGenerator;
	//ShootingSchrodingerEndGenerator endBoundaryGenerator;

	data_t start = -0.00000000002;
	int stepsCount = 100000;
	data_t a = 0.000000000564;
	data_t step = 0.000000000001;

	YuPotential GaAsPotential(asymmetricFormFactors.at("GaAs"), symmetricFormFactors.at("GaAs"), 11, a);
	YuPotential AlAsPotential(asymmetricFormFactors.at("AlAs"), symmetricFormFactors.at("AlAs"), 11, a);
	YuPotential SiPotential(asymmetricFormFactors.at("Si"), symmetricFormFactors.at("Si"), 11, a);
	YuPotential GePotential(asymmetricFormFactors.at("Ge"), symmetricFormFactors.at("Ge"), 16 ,a);
	std::string GaAsPotentialLogName("GaAsPotential");
	std::string AlAsPotentialLogName("AlAsPotential");
	std::string SiPotentialLogName("SiPotential");
	std::string GePotentialLogName("GePotential");
	//logPseudoPotential(GaAsPotential, GaAsPotentialLogName, start, step, stepsCount);
	//logPseudoPotential(AlAsPotential, AlAsPotentialLogName, start, step, stepsCount);
	//logPseudoPotential(SiPotential, SiPotentialLogName, start, step, stepsCount);
	//logPseudoPotential(GePotential, GePotentialLogName, start, step, stepsCount);

	int eigenValeusCount = 4;

	//printPotentialValues(8, SiPotential, step, 50);
	//printPotentialValues(-8, SiPotential, -step, 50);

	testSchrodinger(energyMin, schrodingerStream, schrodingerEnergyStream, AlAsPotential, std::string("AlAsPlus"), std::string("AlAsMinus"), startX, xStep, 
		expandMultiplier, precision, omegaPrecision, cauchyPrecision, energyStep, startValue, startBoundaryGenerator, endBoundaryGenerator, eigenValeusCount);
//
//	std::fstream omegaStream("SiOmegaLogBigX", std::fstream::out);
//	data_t startValue = pow(10.0, -10.0);
//	ShootingSchrodingerStartGenerator startBoundaryGenerator;
//	ShootingSchrodingerEndGenerator endBoundaryGenerator;
//	testOmega(omegaStream, SiPotential, 8, 0, 100000, mass, startValue, startValue, startBoundaryGenerator, endBoundaryGenerator, 0, 0.001, 500);

	//schrodingerEnergyStream.close();
	//schrodingerStream.close();

	//testInfiniteWalls(10, std::cout, mass);
	//testFiniteWalls(10, std::cout, mass, 10);
	//testSmoothLamellar(10, std::cout, mass, 10, 0.00000000000000000001);
	//SmoothedLamellarPotential smoothLamellarPotential(0, 10, -5, 5, 1);
	//logPseudoPotential(smoothLamellarPotential, std::string("lamellarPot"), -10, 0.0002, 100000);
//	testSmoothLamellarPotential();

	//testBrendt(std::cout);
	//testNumerov(std::cout);

	//testScatterMatrix();
}