#ifndef SCHRODINGER_TESTS_H
#define SCHRODINGER_TESTS_H
#include "../common/types.h"
#include <iostream>
#include "../Schrodinger/PotentialFunction.h"
#include "../Schrodinger/SchrodingerBoundaryConditionGenerator.h"

void testSchrodinger(data_t energyMin, std::ostream & logStream, std::ostream & energyStream, PotentialFunction & potential, std::string phiPlusStreamBase,
	std::string phiMinusStreamBase, data_t startX, data_t xStep, data_t expandMultiplier, data_t energyPrecision, data_t omegaPrecision, data_t cauchyPrecision, data_t energyStep,
	data_t startValue, SchrodingerShootingBoundaryConditionGenerator& startConditionGenerator, SchrodingerShootingBoundaryConditionGenerator& endConditionGenerator, int eigenValuesCount);

void testInfiniteWalls(data_t a, std::ostream& logStream, data_t mass);

void testFiniteWalls(data_t a, std::ostream& logStream, data_t mass, data_t potentialValue);

void testSmoothLamellar(data_t a, std::ostream& logStream, data_t mass, data_t potentialValue, data_t epsilon);

void testSmoothLamellarPotential();



#endif //SCHRODINGER_TESTS_H