/*
 * Function.h
 *
 *  Created on: 16.02.2013
 *      Author: 
 */

#ifndef FUNCTION_H_
#define FUNCTION_H_

#include "types.h"

class Function {
public:
	virtual data_t at(data_t x) = 0;
	virtual ~Function();
	void getDiscreteSecondDerivatives(data_t from, data_t to, int pointsCount, data_t * out);
	void getDiscreteSecondDeriavtivesPeriodical(data_t from, data_t to, int pointsCount, data_t * out);
};

enum funBinOpEnum {
	SUM,
	SUB,
	MUL,
	DIV,
	COMP
};

class FunctionBinOp : public Function {
public:
	FunctionBinOp(Function const * const a, Function const * const b, funBinOpEnum newOp);
	data_t at(data_t x);
private:
	Function const * const first;
	Function const * const second;
	funBinOpEnum op;
};

enum funUnOpEnum {
	ADD_RES_CONST,
	MUL_RES_CONST,
	ADD_ARG_CONST,
	MUL_ARG_CONST,
	POW_RES_CONST_ARG,
	POW_RES_CONST_BASE,
	POW_ARG_CONST_ARG,
	POW_ARG_CONST_BASE
};

class FunctionUnOp : public Function {
public:
	FunctionUnOp(Function const * const f, data_t arg, funUnOpEnum op);
	data_t at(data_t x);
private:
	Function const * const fun;
	data_t scalarArg;
	funUnOpEnum opEnum;
};

//Function const& operator-(Function const& a);
//Function const& operator+ (Function const&  a, Function const& b);
//Function const& operator- (Function const& a, Function const& b);
//Function const& operator* (Function const& a, Function const& b);
//Function const& operator/ (Function const& a, Function const& b);
//Function const& operator+ (Function const& a, data_t const& b);
//Function const& operator- (Function const& a, data_t const& b);
//Function const& operator/ (Function const& a, data_t const& b);
//Function const& operator* (Function const& a, data_t const& b);
//Function const& operator+ (data_t const a, Function const& b);
//Function const& operator- (data_t const a, Function const& b);
//Function const& operator/ (data_t const a, Function const& b);
//Function const& operator* (data_t const a, Function const& b);

#endif /* FUNCTION_H_ */
