/*
 * Complex.h
 *
 *  Created on: 28.03.2013
 *      Author: 
 */

#ifndef COMPLEX_H_
#define COMPLEX_H_

#include <cmath>
#include <iostream>

template<typename data_t>
class Complex {
public:
	Complex();
	Complex(data_t newRe);
	Complex(data_t _re, data_t _im);
	Complex(Complex<data_t> const & arg);
	data_t getRe() const;
	data_t getIm() const;
	void setRe(data_t _re);
	void setIm(data_t _im);
	static Complex<data_t> i();

private:
	data_t re;
	data_t im;
};
template<typename data_t>
Complex<data_t> Complex<data_t>::i() {
	return Complex<data_t>(0, 1);
}
template<typename data_t>
Complex<data_t> operator *(Complex<data_t> const & a,
		Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator -(Complex<data_t> const & a,
		Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator +(Complex<data_t> const & a,
		Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator /(Complex<data_t> const & a,
		Complex<data_t> const & b);
template<typename data_t>
Complex<data_t>& operator *=(Complex<data_t> & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t>& operator -=(Complex<data_t> & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t>& operator +=(Complex<data_t> & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t>& operator /=(Complex<data_t> & a, Complex<data_t> const & b);
template<typename data_t>
bool operator==(Complex<data_t> const & a, Complex<data_t> const & b);
template<typename data_t>
bool operator!=(Complex<data_t> const & a, Complex<data_t> const& b);
template<typename data_t>
Complex<data_t> operator -(Complex<data_t> const & a);

template<typename data_t>
bool operator==(Complex<data_t> const & a, data_t const & b);
template<typename data_t>
bool operator==(data_t const & b, Complex<data_t> const & a);
template<typename data_t>
bool operator!=(data_t const & a, Complex<data_t> const& b);
template<typename data_t>
bool operator!=(Complex<data_t> const & a, data_t const& b);
template<typename data_t>
Complex<data_t> operator *(data_t const & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator *(Complex<data_t> const & a, data_t const & b);
template<typename data_t>
Complex<data_t> operator -(data_t const & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator -(Complex<data_t> const & a, data_t const & b);
template<typename data_t>
Complex<data_t> operator +(data_t const & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator +(Complex<data_t> const & a, data_t const & b);
template<typename data_t>
Complex<data_t> operator /(data_t const & a, Complex<data_t> const & b);
template<typename data_t>
Complex<data_t> operator /(Complex<data_t> const & a, data_t const & b);
template<typename data_t>
Complex<data_t>& operator *=(Complex<data_t> & a, data_t const & b);
template<typename data_t>
Complex<data_t>& operator -=(Complex<data_t> & a, data_t const & b);
template<typename data_t>
Complex<data_t>& operator +=(Complex<data_t> & a, data_t const & b);
template<typename data_t>
Complex<data_t>& operator /=(Complex<data_t> & a, data_t const & b);
template<typename data_t>
std::ostream& operator<<(std::ostream &os, Complex<data_t> const &r);

//implementations:
template<typename data_t>
Complex<data_t>::Complex() :
		re(0), im(0) {
}
template<typename data_t>
Complex<data_t>::Complex(data_t newRe) :
		re(newRe), im(0) {
}
template<typename data_t>
Complex<data_t>::Complex(data_t _re, data_t _im) :
		re(_re), im(_im) {
}
template<typename data_t>
Complex<data_t>::Complex(Complex const & arg) :
		re(arg.re), im(arg.im) {
}
;
template<typename data_t>
data_t Complex<data_t>::getRe() const {
	return re;
}
template<typename data_t>
data_t Complex<data_t>::getIm() const {
	return im;
}
template<typename data_t>
void Complex<data_t>::setRe(data_t _re) {
	re = _re;
}
template<typename data_t>
void Complex<data_t>::setIm(data_t _im) {
	im = _im;
}
template<typename data_t>
Complex<data_t> operator *(Complex<data_t> const & fst,
		Complex<data_t> const & snd) {
	Complex<data_t> res(fst);
	return res *= snd;
}
template<typename data_t>
Complex<data_t> operator -(Complex<data_t> const & fst,
		Complex<data_t> const & snd) {
	Complex<data_t> res(fst);
	return res -= snd;
}
template<typename data_t>
Complex<data_t> operator +(Complex<data_t> const & fst,
		Complex<data_t> const & snd) {
	Complex<data_t> res(fst);
	return res += snd;
}
template<typename data_t>
Complex<data_t> operator /(Complex<data_t> const & fst,
		Complex<data_t> const & snd) {
	Complex<data_t> res(fst);
	return res /= snd;
}
template<typename data_t>
Complex<data_t>& operator *=(Complex<data_t> & fst,
		Complex<data_t> const & snd) {
	data_t a = fst.getRe();
	data_t b = fst.getIm();
	data_t c = snd.getRe();
	data_t d = snd.getIm();
	fst.setRe(a * c - b * d);
	fst.setIm(a * d + b * c);
	return fst;
}
template<typename data_t>
Complex<data_t>& operator -=(Complex<data_t> & fst,
		Complex<data_t> const & snd) {
	fst.setRe(fst.getRe() - snd.getRe());
	fst.setIm(fst.getIm() - snd.getIm());
	return fst;
}
template<typename data_t>
Complex<data_t>& operator +=(Complex<data_t> & fst,
		Complex<data_t> const & snd) {
	fst.setRe(fst.getRe() + snd.getRe());
	fst.setIm(fst.getIm() + snd.getIm());
	return fst;
}
template<typename data_t>
Complex<data_t>& operator /=(Complex<data_t> & fst,
		Complex<data_t> const & snd) {
	data_t a = fst.getRe();
	data_t b = fst.getIm();
	data_t c = snd.getRe();
	data_t d = snd.getIm();
	data_t denom = c * c + d * d;
	fst.setRe((a * c + b * d) / denom);
	fst.setIm((b * c - a * d) / denom);
	return fst;
}
template<typename data_t>
bool operator==(Complex<data_t> const & fst, Complex<data_t> const & snd) {
	return fst.getRe() == snd.getRe() && fst.getIm() == snd.getIm();
}
template<typename data_t>
bool operator!=(Complex<data_t> const & fst, Complex<data_t> const& snd) {
	return !(fst == snd);
}
template<typename data_t>
Complex<data_t> operator -(Complex<data_t> const & a) {
	return Complex<data_t>(a.getRe(), a.getIm());
}

template<typename data_t>
bool operator==(Complex<data_t> const & a, data_t const & b) {
	return a.getIm() == 0 && a.getRe() == b;
}
template<typename data_t>
bool operator==(data_t const & b, Complex<data_t> const & a) {
	return a == b;
}
template<typename data_t>
bool operator!=(data_t const & a, Complex<data_t> const& b) {
	return b.getIm() != 0 || b.getRe() != 0;
}
template<typename data_t>
bool operator!=(Complex<data_t> const & a, data_t const& b) {
	return b != a;
}
template<typename data_t>
Complex<data_t> operator *(data_t const & a, Complex<data_t> const & b) {
	return Complex<data_t>(a * b.getRe(), a * b.getIm());
}
template<typename data_t>
Complex<data_t> operator *(Complex<data_t> const & a, data_t const & b) {
	return Complex<data_t>(b * a.getRe(), b * a.getIm());
}

template<typename data_t>
Complex<data_t> operator -(data_t const & a, Complex<data_t> const & b) {
	return Complex<data_t>(a - b.getRe(), -b.getIm());
}
template<typename data_t>
Complex<data_t> operator -(Complex<data_t> const & a, data_t const & b) {
	return Complex<data_t>(a.getRe() - b, a.getIm());
}
template<typename data_t>
Complex<data_t> operator +(data_t const & a, Complex<data_t> const & b) {
	return Complex<data_t>(a + b.getRe(), b.getIm());
}
template<typename data_t>
Complex<data_t> operator +(Complex<data_t> const & a, data_t const & b) {
	return Complex<data_t>(a.getRe() + b, a.getIm());
}
template<typename data_t>
Complex<data_t> operator /(data_t const & a, Complex<data_t> const & b) {
	Complex<data_t> res(a);
	return res /= b;
}
template<typename data_t>
Complex<data_t> operator /(Complex<data_t> const & a, data_t const & b) {
	return Complex<data_t>(a.getRe() / b, a.getIm() / b);
}
template<typename data_t>
Complex<data_t>& operator *=(Complex<data_t> & a, data_t const & b) {
	a.setRe(a.getRe() * b);
	a.setIm(a.getIm() * b);
	return a;
}
template<typename data_t>
Complex<data_t>& operator -=(Complex<data_t> & a, data_t const & b) {
	a.setRe(a.getRe() - b);
	return a;
}
template<typename data_t>
Complex<data_t>& operator +=(Complex<data_t> & a, data_t const & b) {
	a.setRe(a.getRe() + b);
	return a;
}
template<typename data_t>
Complex<data_t>& operator /=(Complex<data_t> & a, data_t const & b) {
	a.setRe(a.getRe() / b);
	a.setIm(a.getIm() / b);
	return a;
}

template<typename data_t>
inline Complex<data_t> exp(Complex<data_t> const & arg) {
	return Complex<data_t>(cos(arg.getRe()), sin(arg.getIm()));
}

template<typename data_t>
std::ostream& operator<<(std::ostream &os, Complex<data_t> const &r) {
	os << r.getRe() << "+" << r.getIm() << "i";
	return os;
}

#endif /* COMPLEX_H_ */
