/*
 * Vector.h
 *
 *  Created on: 04.04.2013
 *      Author: 
 */

#ifndef VECTOR_H_
#define VECTOR_H_

#include "../common/types.h"
#include <vector>
#include <iostream>
#include <cstdlib>

template <typename data_t>
class Vector {
public:
	Vector(size_t size);
	Vector(Vector<data_t> const & arg);
	std::vector<data_t>& getValues();
	data_t getValue(size_t position) const;
	void setValue(size_t position, data_t const & value);
	data_t scalarMul(Vector<data_t> const& arg) const;
	Vector<data_t> vectorMul(Vector<data_t> const& arg) const;
	size_t getSize() const;
private:
	size_t size;
	std::vector<data_t> data;
};

template<typename data_t>
Vector<data_t>& operator -=(Vector<data_t> & a, Vector<data_t> const & b);
template<typename data_t>
Vector<data_t>& operator +=(Vector<data_t> & a, Vector<data_t> const & b);
template<typename data_t>
bool operator==(Vector<data_t> const & a, Vector<data_t> const & b);
template<typename data_t>
bool operator!=(Vector<data_t> const & a, Vector<data_t> const& b);
template<typename data_t>
Vector<data_t> operator -(Vector<data_t> const & a);
template<typename data_t>
Vector<data_t> operator+(Vector <data_t> const & a, Vector<data_t> const & b);
template<typename data_t>
Vector<data_t> operator-(Vector <data_t> const& a, Vector<data_t> const & b);
template<typename data_t>
std::ostream& operator<<(std::ostream &os, Vector<data_t> const &r);

template<typename data_t>
Vector<data_t>::Vector(size_t _size) {
	size = _size;
	for (size_t i = 0; i < size; ++i) {
		data.push_back(0);
	}
}
template<typename data_t>
Vector<data_t>::Vector(Vector<data_t> const & arg) {
	size = arg.getSize();
	for (size_t i = 0; i < size; ++i) {
		data.push_back(arg.getValue(i));
	}
}
template<typename data_t>
data_t Vector<data_t>::getValue(size_t position) const {
	return data.at(position);
}
template<typename data_t>
std::vector<data_t>& Vector<data_t>::getValues() {
	return data;
}
template<typename data_t>
void Vector<data_t>::setValue(size_t position, data_t const & value) {
	data.at(position) = value;
}
template<typename data_t>
size_t Vector<data_t>::getSize() const{
	return data.size();
}
template<typename data_t>
data_t Vector<data_t>::scalarMul(Vector<data_t> const& arg) const {
	data_t res = 0;
	for (size_t i = 0; i < size; ++i) {
		res += data.at(i) * arg.getValue(i);
	}
	return res;
}
template <typename data_t>
Vector<data_t> Vector<data_t>::vectorMul(Vector<data_t> const& arg) const {
	size_t size = arg.getSize();
	if (size != 3) {
		std::cerr << "Vector multiplication for vectors of size other than 3. Exiting" << std::endl;
		exit(69);
	}
	Vector<data_t> result(arg.getSize());
	data_t a_x = getValue(0);
	data_t a_y = getValue(1);
	data_t a_z = getValue(2);
	data_t b_x = arg.getValue(0);
	data_t b_y = arg.getValue(1);
	data_t b_z = arg.getValue(2);
	result.setValue(0, a_y * b_z - a_z * b_y);
	result.setValue(1, a_z * b_x - a_x * b_z);
	result.setValue(2, a_x * b_y - a_y * b_x);
	return result;
}
template<typename data_t>
Vector<data_t>& operator -=(Vector<data_t> & a, Vector<data_t> const & b) {
	std::vector<data_t>& data = a.getValues();
	for (int i = 0; i < data.getSize(); ++i) {
		data.at(i) = data.at(i) - b.getValue(i);
	}
	return a;
}
template<typename data_t>
Vector<data_t>& operator +=(Vector<data_t> & a, Vector<data_t> const & b) {
	std::vector<data_t>& data = a.getValues();
	for (int i = 0; i < data.getSize(); ++i) {
		data.at(i) = data.at(i) + b.getValue(i);
	}
	return a;
}
template<typename data_t>
bool operator==(Vector<data_t> const & a, Vector<data_t> const & b) {
	bool res = true;
	for (int i = 0; i < a.getSize(); ++i) {
		res = res && (a.getValue(i) == b.getValue(i));
	}
	return res;
}
template<typename data_t>
bool operator!=(Vector<data_t> const & a, Vector<data_t> const& b) {
	return !(a == b);
}
template<typename data_t>
Vector<data_t> operator -(Vector<data_t> const & a) {
	data_t res = a;
	std::vector<data_t>& data = res.getValues();
	for (int i = 0; i < res.getSize(); ++i) {
		data.at(i) = -data.at(i);
	}
	return res;
}
template<typename data_t>
Vector<data_t> operator+(Vector <data_t> const & a, Vector<data_t> const & b) {
	data_t res(a);
	res += b;
	return res;
}
template<typename data_t>
Vector<data_t> operator-(Vector <data_t> const& a, Vector<data_t> const & b) {
	data_t res(a);
	res -= b;
	return res;
}

template<typename data_t>
std::ostream& operator<<(std::ostream &os, Vector<data_t> const &r) {
	os << "(";
	for (size_t i = 0; i < r.getSize() - 1; ++i) {
		os << r.getValue(i) << ",";
	}
	os << r.getValue(r.getSize() - 1) << ")";
	return os;
}

#endif /* VECTOR_H_ */
