#ifndef SCHRODINGER_BOUNDARY_CONDITION_GENERATOR_H
#define SCHRODINGER_BOUNDARY_CONDITION_GENERATOR_H

#include "../common/types.h"
#include "PotentialFunction.h"

class SchrodingerShootingBoundaryConditionGenerator {
public:
	virtual data_t getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential) = 0;
	virtual bool isValid(PotentialFunction& potential, data_t energy, data_t point);
};

class ShootingSchrodingerStartGenerator : public SchrodingerShootingBoundaryConditionGenerator {
public:
	data_t getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential);
	bool isValid(PotentialFunction& potential, data_t energy, data_t point);
};

class ShootingSchrodingerEndGenerator : public SchrodingerShootingBoundaryConditionGenerator {
public:
	data_t getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential);
	bool isValid(PotentialFunction& potential, data_t energy, data_t point);
};

class ConstShootingSchrodingerGenerator : public SchrodingerShootingBoundaryConditionGenerator {
public:
	ConstShootingSchrodingerGenerator(data_t _derivative);
	data_t getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential);
private:
	data_t derivative;
};

#endif //SCHRODINGER_BOUNDARY_CONDITION_GENERATOR_H