#include "SchrodingerBoundaryConditionGenerator.h"

bool SchrodingerShootingBoundaryConditionGenerator::isValid(PotentialFunction& potential, data_t energy, data_t point) {
	return true;
}

data_t ShootingSchrodingerStartGenerator::getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential) {
	data_t res = value * sqrt(potential.at(point) - E);
	return res;
}

bool ShootingSchrodingerStartGenerator::isValid(PotentialFunction& potential, data_t energy, data_t point) {
		return potential.isValid(energy, point);
}

data_t ShootingSchrodingerEndGenerator::getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential) {

	return -value * sqrt(potential.at(point) - E);
}

bool ShootingSchrodingerEndGenerator::isValid(PotentialFunction& potential, data_t energy, data_t point) {
		return potential.isValid(energy, point);
}

data_t ConstShootingSchrodingerGenerator::getDerivative(data_t point, data_t value, data_t E, PotentialFunction & potential) {
	return derivative;
}

ConstShootingSchrodingerGenerator::ConstShootingSchrodingerGenerator(data_t _derivative) : derivative(_derivative) {}