/*
 * OmegaFunction.h
 *
 *  Created on: 20.02.2013
 *      Author: 
 */

#ifndef OMEGAFUNCTION_H_
#define OMEGAFUNCTION_H_

#include "PotentialFunction.h"
#include "SchrodingerBoundaryConditionGenerator.h"
#include <iostream>
#include <vector>

class OmegaFunction : public Function {
public:
	data_t at(data_t x);
	OmegaFunction(PotentialFunction & newPot, data_t newXMin, data_t newXStep, int pointsCount, data_t newMmass, data_t _startValue, data_t _endValue, 
		SchrodingerShootingBoundaryConditionGenerator & _startBoundaryGenerator, SchrodingerShootingBoundaryConditionGenerator & _endBoundaryGenerator, 
		std::vector<data_t>& _phiPlusX, std::vector<data_t>& _phiMinusX, std::vector<data_t>& _phiPlusY, std::vector<data_t>& _phiMinusY);
	std::vector<data_t>& getPhiPlusX();
	std::vector<data_t>& getPhiPlusY();
	std::vector<data_t>& getPhiMinusX();
	std::vector<data_t>& getPhiMinusY();
private:
	PotentialFunction & potential;
	data_t xMin;
	data_t xStep;
	data_t mass;
	int pointsCount;
	data_t startValue;
	data_t endValue;
	SchrodingerShootingBoundaryConditionGenerator & startBoundaryGenerator;
	SchrodingerShootingBoundaryConditionGenerator & endBoundaryGenerator;
	std::vector<data_t>& phiPlusX;
	std::vector<data_t>& phiMinusX;
	std::vector<data_t>& phiPlusY;
	std::vector<data_t>& phiMinusY;
};


#endif /* OMEGAFUNCTION_H_ */
