﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;

namespace FormGenerator.View.View
{
    public partial class ViewProperties : BaseForm
    {
        Repository.View view;

        private BindingList<Class> selectedClasses;
        private BindingList<Class> notSelectedClasses;

        private BindingList<Relation> relations;
        private BindingList<FieldInClass> fields;

        public ViewProperties(Repository.View view)
        {
            InitializeComponent();

            selectedClasses = new BindingList<Class>();
            notSelectedClasses = new BindingList<Class>();
            relations = new BindingList<Relation>();
            fields = new BindingList<FieldInClass>();

            if (view != null)
            {
                textBoxViewLogicName.Text = view.LogicName;
                foreach (ClassInView c in view.Classes)
                {
                    selectedClasses.Add(c.Class);
                }
               
            }

            foreach (Class c in Repository.Repository.Instance.Classes)
            {
                if (!selectedClasses.Contains(c))
                {
                    notSelectedClasses.Add(c);
                }
            }

            listBoxNotSelectedClasses.DataSource = notSelectedClasses;
            listBoxSelectedClasses.DataSource = selectedClasses;

            listBoxNotSelectedClasses.Refresh();
            listBoxSelectedClasses.Refresh();

            UpdateRelationsList();
            UpdateFieldsList();
        }

        private void buttonSelectClass_Click(object sender, EventArgs e)
        {
            if (listBoxNotSelectedClasses.SelectedItem != null)
            {
                selectedClasses.Add((Class)listBoxNotSelectedClasses.SelectedItem);
                notSelectedClasses.Remove((Class)listBoxNotSelectedClasses.SelectedItem);

                listBoxNotSelectedClasses.Refresh();
                listBoxSelectedClasses.Refresh();

            }
            UpdateRelationsList();
            UpdateFieldsList();

            foreach (FieldInClass field in fields)
            {
                if (!checkedListBoxFields.Items.Contains(field))
                {
                    checkedListBoxFields.Items.Add(field);
                }
            }

        }

        private void buttonRemoveClass_Click(object sender, EventArgs e)
        {
            if (listBoxSelectedClasses.SelectedItem != null)
            {
                notSelectedClasses.Add((Class)listBoxSelectedClasses.SelectedItem);
                selectedClasses.Remove((Class)listBoxSelectedClasses.SelectedItem);

                listBoxNotSelectedClasses.Refresh();
                listBoxSelectedClasses.Refresh();

            }
            UpdateRelationsList();
            UpdateFieldsList();

        }

        private void UpdateRelationsList()
        {
            relations.Clear();
            foreach (Class slave in selectedClasses)
            {
                foreach (Relation r in Repository.Repository.Instance.GetMasterClassesRelations(slave))
                {
                    if (selectedClasses.Contains(r.MasterClass))
                    {
                        relations.Add(r);
                    }

                }
            }


            foreach (Relation relation in relations)
            {
                if (!checkedListBoxRelations.Items.Contains(relation))
                {
                    checkedListBoxRelations.Items.Add(relation);
                }
            }

            List<Relation> itemsToRemove = new List<Relation>();
            foreach (Relation item in checkedListBoxRelations.Items)
            {
                if (!relations.Contains(item))
                {
                    itemsToRemove.Add(item);
                }
            }
            foreach (Relation relation in itemsToRemove)
            {
                checkedListBoxRelations.Items.Remove(relation);
            }


        }

        private void UpdateFieldsList()
        {
            fields.Clear();
            foreach (Class c in selectedClasses)
            {
                foreach (Field f in c.Fields)
                {
                    FieldInClass newFieldInClass = new FieldInClass(f, c);
                    fields.Add(newFieldInClass);
                }
            }


            foreach (FieldInClass field in fields)
            {
                if (!checkedListBoxFields.Items.Contains(field))
                {
                    checkedListBoxFields.Items.Add(field);
                }
            }

            List<FieldInClass> itemsToRemove = new List<FieldInClass>();
            foreach (FieldInClass item in checkedListBoxFields.Items)
            {
                if (!fields.Contains(item))
                {
                    itemsToRemove.Add(item);
                }
            }
            foreach (FieldInClass field in itemsToRemove)
            {
                checkedListBoxFields.Items.Remove(field);
            }


        }

        private class FieldInClass
        {
            public FieldInClass(Field f, Class c)
            {
                this.field = f;
                this.c = c;
            }

            private Field field;

            public Field Field
            {
                get { return field; }
                set { field = value; }
            }
            private Class c;

            public Class Class
            {
                get { return c; }
                set { c = value; }
            }
            public override string ToString()
            {
                return field.LogicName + " (" + c.LogicName + ")";
            }
            public override bool Equals(object obj)
            {
                if (obj is FieldInClass)
                {
                    return ((field.Equals(((FieldInClass)obj).Field)) & (c.Equals(((FieldInClass)obj).Class)));
                }
                return base.Equals(obj);
            }
            public override int GetHashCode()
            {
                return field.GetHashCode() + c.GetHashCode();
            }

        }

        protected override void SaveData()
        {
        
            if (textBoxViewLogicName.Text.Equals(""))
            {
                MessageBox.Show("Empty view name");
                throw new Exception();
                
            }
            bool isAddNew = false;
            if (view == null)
            {
                view = new Repository.View();
                isAddNew = true;
            }
            view.LogicName = textBoxViewLogicName.Text;
            foreach (Relation relation in checkedListBoxRelations.CheckedItems)
            {
                view.Relations.Add(relation);
            }
            foreach (Class c in selectedClasses)
            {
                ClassInView ciw = new ClassInView();
                ciw.Class = c;
                foreach (FieldInClass fieldInView in checkedListBoxFields.CheckedItems)
                {
                    if (fieldInView.Class.Equals(c))
                    {
                        ciw.Fields.Add(fieldInView.Field);
                    }
                }
                view.Classes.Add(ciw);
            }
            if (isAddNew)
            {
                Repository.Repository.Instance.Views.Add(view);
            }
        }
    }


}
