﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class NewTreeForm : System.Windows.Forms.Form
    {
        private Folder currentFolder; 
        public NewTreeForm(Folder f)
        {
            InitializeComponent();

            foreach (Class c in Repository.Repository.Instance.Classes)
            {
                if (Repository.Repository.IsHasRecursiveLink(c))
                {
                    viewComboBox.Items.Add(c);
                }
            }
            currentFolder = f;
        }

        

        private void AddNewListButton_Click(object sender, EventArgs e)
        {

            
            Repository.Repository.Instance.AddNewTree(listNameTextBox.Text, logicNameTextBox.Text, (Repository.Class)viewComboBox.SelectedItem, currentFolder);
            
            
            this.Close();
        }

        private void viewComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (viewComboBox.SelectedItem is Repository.View)
            {
                listNameTextBox.Text = ((Repository.View)viewComboBox.SelectedItem).Name;
                logicNameTextBox.Text = ((Repository.View)viewComboBox.SelectedItem).LogicName;
            }
            else
            {
                
                listNameTextBox.Text = ((Repository.Class)viewComboBox.SelectedItem).Name+"sTree";
                logicNameTextBox.Text = ((Repository.Class)viewComboBox.SelectedItem).LogicName;
            }
        }
    }
}
