﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FormGenerator.Repository.Forms;
using System.Windows.Forms;
using System.Drawing;

namespace FormGenerator.View
{
    public class ViewClassNode:TreeNode
    {
        public ViewClassNode(ListTreeNodeClass node )
        {
            Node = node;
            Text = node.Class.LogicName;
        }

        private ListTreeNodeClass node;
        public ListTreeNodeClass Node
        {
            get { return node; }
            set { node = value; }
        }

        public void MakeFilter()
        {
            if (node.IsFilter)
            {
                NodeFont = new Font(FontFamily.GenericSerif, 10, FontStyle.Bold);
            }
            else
            {
                NodeFont = new Font(FontFamily.GenericSerif, 10, FontStyle.Regular);
            }
        }
    }
}
