﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class NewListForm : System.Windows.Forms.Form
    {
        private Folder currentFolder; 
        public NewListForm(Folder f)
        {
            InitializeComponent();
            foreach (Repository.View v in Repository.Repository.Instance.Views)
            {
                viewComboBox.Items.Add(v);
            }
            foreach (Class c in Repository.Repository.Instance.Classes)
            {
                viewComboBox.Items.Add(c);
            }
            currentFolder = f;
        }

        private void AddNewListButton_Click(object sender, EventArgs e)
        {
            if (viewComboBox.SelectedItem is Repository.View)
            {
                Repository.Repository.Instance.AddNewList(listNameTextBox.Text, logicNameTextBox.Text, (Repository.View)viewComboBox.SelectedItem, checkBoxIsAux.Checked, currentFolder);
            }
            else
            {
                Repository.Repository.Instance.AddNewList(listNameTextBox.Text, logicNameTextBox.Text, (Repository.Class)viewComboBox.SelectedItem, checkBoxIsAux.Checked, currentFolder);
            }
            
            this.Close();
        }

        private void viewComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (viewComboBox.SelectedItem is Repository.View)
            {
                listNameTextBox.Text = ((Repository.View)viewComboBox.SelectedItem).Name;
                logicNameTextBox.Text = ((Repository.View)viewComboBox.SelectedItem).LogicName;
            }
            else
            {
                
                listNameTextBox.Text = ((Repository.Class)viewComboBox.SelectedItem).Name+"sList";
                logicNameTextBox.Text = ((Repository.Class)viewComboBox.SelectedItem).LogicName;
            }
        }
    }
}
