﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;
using FormGenerator.Repository;

namespace FormGenerator.View
{
    public partial class FilterProperties : FormGenerator.View.BaseForm
    {
        private static string NO_FILTER = "no filter";
      
        private ListTreeNode node;

        public FilterProperties(ListTreeNode node)
        {
            this.node = node;
            InitializeComponent();
            InitializeFilterComboBox();
            

        }

        private void InitializeFilterComboBox()
        {
            if (node is ListTreeNodeAttribute)
            {
                comboBoxFilterType.Enabled = false;
                comboBoxFilterType.Items.Add(NO_FILTER);
                comboBoxFilterType.Items.Add(FilterAttributeType.EQUALS);
                comboBoxFilterType.Items.Add(FilterAttributeType.FROM);
                comboBoxFilterType.Items.Add(FilterAttributeType.TO);
                comboBoxFilterType.Items.Add(FilterAttributeType.FROM_TO);

                comboBoxSortingDirection.Items.Add(ListTreeNodeAttribute.NO_SORTING);
                comboBoxSortingDirection.Items.Add(ListTreeNodeAttribute.SORTING_ASC);
                comboBoxSortingDirection.Items.Add(ListTreeNodeAttribute.SORTING_DESC);

                if (((ListTreeNodeAttribute)node).SortingType != null)
                {
                    comboBoxSortingDirection.SelectedItem = ((ListTreeNodeAttribute)node).SortingType;
                }
                else
                {
                    comboBoxSortingDirection.SelectedItem = ListTreeNodeAttribute.NO_SORTING;
                }

                if (node.IsFilter)
                {
                    comboBoxFilterType.SelectedItem = ((ListTreeNodeAttribute)node).FilterType;
                }
                else
                {
                    comboBoxFilterType.SelectedIndex = 0;
                }
                textBoxColumnName.Text = ((ListTreeNodeAttribute)node).ColumnName;

            }
            else
            {
                textBoxColumnName.Enabled = false;
                comboBoxSortingDirection.Enabled = false;
                comboBoxFilterType.Items.Add(NO_FILTER);


                foreach (Field field in ((ListTreeNodeClass)node).Class.Fields)
                {
                    comboBoxFilterType.Items.Add(field);
                }
                if (node.IsFilter)
                {
                    comboBoxFilterType.SelectedItem = ((ListTreeNodeClass)node).FilteredField;
                }
                else
                {
                    comboBoxFilterType.SelectedIndex = 0;
                }
                
            }



        }

        protected override void SaveData()
        {
            if (node is ListTreeNodeAttribute)
            {
                if (comboBoxFilterType.SelectedItem.Equals(NO_FILTER))
                {
                    node.IsFilter = false;
                    ((ListTreeNodeAttribute)node).FilterType = null;
                }
                else
                {
                    node.IsFilter = true;
                    ((ListTreeNodeAttribute)node).FilterType = comboBoxFilterType.SelectedItem.ToString();
                }
                ((ListTreeNodeAttribute)node).ColumnName = textBoxColumnName.Text;

                ((ListTreeNodeAttribute)node).SortingType = comboBoxSortingDirection.SelectedItem.ToString();
              
            }
            else
            {
                if (comboBoxFilterType.SelectedItem.Equals(NO_FILTER))
                {
                    node.IsFilter = false;
                    ((ListTreeNodeClass)node).FilteredField = null;
                }
                else
                {
                    node.IsFilter = true;
                    ((ListTreeNodeClass)node).FilteredField = (Field)(comboBoxFilterType.SelectedItem);
                }
                

            }

        }

    }
}
