﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class AuxListProperties : FormGenerator.View.BaseForm
    {
        private CardAuxListNode node;
        public AuxListProperties(CardAuxListNode node)
        {
            InitializeComponent();
            this.node = node;
            InitializeListComboBox();
        }

        private void InitializeListComboBox()
        {
            comboBoxAuxList.Items.Add("no");
            comboBoxAuxList.SelectedIndex = 0;
            foreach(List list in Repository.Repository.Instance.GetAuxLists(node.AuxListField.SlaveClass))
            {
                comboBoxAuxList.Items.Add(list);
                if (list.Equals(node.AuxListField.List))
                {
                    comboBoxAuxList.SelectedItem = list;
                }
            }
            
        }
        protected override void SaveData()
        {
            if (comboBoxAuxList.SelectedIndex == 0)
            {
                node.AuxListField.List = null;
            }
            else
            {
                node.AuxListField.List = (List)(comboBoxAuxList.SelectedItem);
            }

        }
    }
}
