﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseXMIDocument
{
    public class SendSignalAction :IDiagramObject
    {
        public enum EventType
        {
            StartEvent,
            IntermediateEvent,
            EndEvent
        };
        private EventType type;

        public EventType Type
        {
            get { return type; }
            set { type = value; }
        }
        private string _Name;
        public string Name
        {
            get
            {
                return _Name;
            }
            set
            {
                _Name = value;
            }
        }
        public List<string> Incoming { get; set; }
        public List<string> Outgoing { get; set; }
        public SendSignalAction(string name, List<string> incoming, List<string> outgoing, EventType type)
        {
            Name = name;
            Incoming = incoming;
            Outgoing = outgoing;
            Type = type;
        }
    }
}
