﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

using ParseXMIDocument;

namespace TestProject
{
    public class Pool
    {
        private string name;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }
        private List<Connection> connections;

        public List<Connection> Connections
        {
            get { return connections; }
            set { connections = value; }
        }

        public Pool(string name, List<Connection> conn)
        {
            Name = name;
            Connections = conn;
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("pool",
                    new XAttribute("name", Name),
                    new XElement("connections",
                        from connection in Connections
                            select connection.XElement));
                return xelement;
            }
        }
    }
}
