﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using System.Text;
using System.Xml;
using TestProject;
namespace ParseXMIDocument
{
    public class ParseXMI
    {
        public enum DiagramElement
        {
            ExclusiveGate,
            OtherGate,
            AbstractActivity,
            ScriptActivity,
            UserActivity,
            OtherActivity,
            StartEvent,
            IntermediateEvent,
            EndEvent,
            Other
        };
        public static bool isState(DiagramElement type)
        {
            if (type == ParseXMI.DiagramElement.StartEvent ||
                    type == ParseXMI.DiagramElement.IntermediateEvent ||
                    type == ParseXMI.DiagramElement.EndEvent ||
                    type == ParseXMI.DiagramElement.UserActivity ||
                    type == ParseXMI.DiagramElement.ScriptActivity)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        private static Activity.ActivityType detectActivityType(string name)
        {
            if (name == "Abstract")
            {
                return Activity.ActivityType.Abstract;
            }
            else if (name == "Script")
            {
                return Activity.ActivityType.Script;
            }
            else if (name == "User")
            {
                return Activity.ActivityType.User;
            }
            else
            {
                return Activity.ActivityType.Other; 
            }
        }
        private static Dictionary<string, Activity.ActivityType> getActivityTypes(XElement root, XNamespace ns)
        {
            var activities = root.Descendants(ns + "Activity").ToList();
            var result = new Dictionary<string, Activity.ActivityType>();
            foreach (var elem in activities)
            {
                string base_Activity = elem.Attribute("base_Activity").Value;
                string taskType = elem.Attribute("taskType").Value; 
                Activity.ActivityType atype = detectActivityType(taskType);
                result.Add(base_Activity, atype);
            }
            return result;
        }
        private static DecisionNode.GateType detectDecisionNodeType(string name)
        {
            if (name == "Exclusive")
            {
                return DecisionNode.GateType.Exclusive;
            }
            else
            {
                return DecisionNode.GateType.Other;
            }
        }
        private static Dictionary<string, DecisionNode.GateType> getDecisionNodeType(XElement root, XNamespace ns)
        {
            var gateway = root.Descendants(ns + "Gateway").ToList();
            var result = new Dictionary<string, DecisionNode.GateType>();
            foreach (var elem in gateway)
            {
                string base_DecisionNode = elem.Attribute("base_DecisionNode").Value;
                string gatewayType = elem.Attribute("gatewayType").Value;

                DecisionNode.GateType gtype = detectDecisionNodeType(gatewayType);
                result.Add(base_DecisionNode, gtype); 
            }
            return result;
        }
        private static Dictionary<string, SendSignalAction.EventType> getSendSignalActionType(XElement root, XNamespace ns)
        {
            var start = root.Descendants(ns + "StartEvent").ToList();
            var intermediate = root.Descendants(ns + "IntermediateEvent").ToList();
            var end = root.Descendants(ns + "EndEvent").ToList();
            var result = new Dictionary<string, SendSignalAction.EventType>();

            foreach (var elem in start)
            {
                string base_SendSignalAction = elem.Attribute("base_SendSignalAction").Value;
                SendSignalAction.EventType etype = SendSignalAction.EventType.StartEvent;
                result.Add(base_SendSignalAction, etype);
            }
            foreach (var elem in intermediate)
            {
                string base_SendSignalAction = elem.Attribute("base_SendSignalAction").Value;
                SendSignalAction.EventType etype = SendSignalAction.EventType.IntermediateEvent;
                result.Add(base_SendSignalAction, etype);
            }
            foreach (var elem in end)
            {
                string base_SendSignalAction = elem.Attribute("base_SendSignalAction").Value;
                SendSignalAction.EventType etype = SendSignalAction.EventType.EndEvent;
                result.Add(base_SendSignalAction, etype);
            }
            return result;
        }
        private static DiagramElement detectType(IDiagramObject value)
        {
            DiagramElement type;
            if (value is DecisionNode)
            {
                DecisionNode dn = (DecisionNode)value;
                if (dn.Type == DecisionNode.GateType.Exclusive)
                {
                    type = DiagramElement.ExclusiveGate;
                }
                else
                {
                    type = DiagramElement.OtherGate;
                }
            }
            else if (value is Activity)
            {
                Activity act = (Activity)value;
                if (act.Type == Activity.ActivityType.Script)
                {
                    type = DiagramElement.ScriptActivity;
                }
                else if (act.Type == Activity.ActivityType.User)
                {
                    type = DiagramElement.UserActivity;
                }
                else if (act.Type == Activity.ActivityType.Abstract)
                {
                    type = DiagramElement.AbstractActivity;
                }
                else
                {
                    type = DiagramElement.OtherActivity;
                }
            }
            else if (value is SendSignalAction)
            {
                SendSignalAction ssa = (SendSignalAction)value;
                if (ssa.Type == SendSignalAction.EventType.StartEvent)
                {
                    type = DiagramElement.StartEvent;
                }
                else if (ssa.Type == SendSignalAction.EventType.IntermediateEvent)
                {
                    type = DiagramElement.IntermediateEvent;
                }
                else
                {
                    type = DiagramElement.EndEvent;
                }
            }
            else
            {
                type = DiagramElement.Other;
            }
            return type;
        }
        private static DiagramElement detectDiagramElementByActivityType(Activity.ActivityType type)
        {
            if (type == Activity.ActivityType.Abstract)
            {
                return DiagramElement.AbstractActivity;
            }
            else if (type == Activity.ActivityType.Script)
            {
                return DiagramElement.ScriptActivity;
            }
            else if (type == Activity.ActivityType.User)
            {
                return DiagramElement.UserActivity;
            }
            else
            {
                return DiagramElement.OtherActivity;
            }
        }
        private static DiagramElement detectDiagramElementByEventType(SendSignalAction.EventType type)
        {
            if (type == SendSignalAction.EventType.StartEvent)
            {
                return DiagramElement.StartEvent;
            }
            else if (type == SendSignalAction.EventType.IntermediateEvent)
            {
                return DiagramElement.IntermediateEvent;
            }
            else
            {
                return DiagramElement.EndEvent;
            }
        }
        private static DiagramElement determineDiagramElementTypeById
            (string id, Dictionary<string, Activity.ActivityType> activityTypes, Dictionary<string, SendSignalAction.EventType> sendSignalActionTypes)
        {
            if (activityTypes.Keys.Contains(id))
            {
                return detectDiagramElementByActivityType(activityTypes[id]);
            }
            else
            {
                return detectDiagramElementByEventType(sendSignalActionTypes[id]);
            }
        }
        public static DiagramElement determineDiagramElementByName(string name)
        {
            if (name == "ExclusiveGate")
            {
                return DiagramElement.ExclusiveGate;
            }
            else if (name == "OtherGate")
            {
                return DiagramElement.OtherGate;
            }
            else if (name == "AbstractActivity")
            {
                return DiagramElement.AbstractActivity;
            }
            else if (name == "ScriptActivity")
            {
                return DiagramElement.ScriptActivity;
            }
            else if (name == "UserActivity")
            {
                return DiagramElement.UserActivity;
            }
            else if (name == "OtherActivity")
            {
                return DiagramElement.OtherActivity;
            }
            else if (name == "StartEvent")
            {
                return DiagramElement.StartEvent;
            }
            else if (name == "IntermediateEvent")
            {
                return DiagramElement.IntermediateEvent;
            }
            else if (name == "EndEvent")
            {
                return DiagramElement.EndEvent;
            }
            else
            {
                return DiagramElement.Other;
            }
        }
        private static void recursiveBuildingOfTree
            (string currId, MultiDict<string, string> edgesControlFlow, TreeNode<string> currTree, Dictionary<string, IDiagramObject> dictionary)
        {
            var childs = edgesControlFlow[currId];
            if (childs != null)
            {
                foreach (var elem in childs)
                {
                    var value = dictionary[elem];
                    var name = value.Name.Replace(" ", "") + "State";

                    DiagramElement type = detectType(value);
                    TreeNode<string> childNode = currTree.AddChild(name, type);
                    // Or delete this node from Tree
                    if (value is DecisionNode)
                        childNode.IsState = false;
                    recursiveBuildingOfTree(elem, edgesControlFlow, childNode, dictionary);
                }
            }
            //throw new NotImplementedException();
        }
        public static List<InformationFlow> getInformationFlows(string filename)
        {
            using (XmlReader reader = XmlReader.Create(filename))
            {
                XElement root = XElement.Load(reader);
                XNamespace nsXmi = root.Attribute(XNamespace.Xmlns + "xmi").Value;
                XNamespace nsUml = root.Attribute(XNamespace.Xmlns + "uml").Value;
                XNamespace nsBPMN20 = root.Attribute(XNamespace.Xmlns + "BPMN2.0").Value;
                reader.Close();
                XElement superRoot = root.Element(nsUml + "Model");
                root = root.Element(nsUml + "Model").Element("packagedElement");
                var packageElements = (from pe in root.Descendants("packagedElement")
                                       select pe).ToList();
                Dictionary<string, Activity.ActivityType> activityTypes = getActivityTypes(superRoot, nsBPMN20);
                Dictionary<string, SendSignalAction.EventType> sendSignalActionTypes = getSendSignalActionType(superRoot, nsBPMN20);

                Dictionary<string, InformationFlow> dictionaryInformationFlows = extractInformationFlows(nsXmi, packageElements, activityTypes, sendSignalActionTypes);
                return dictionaryInformationFlows.Values.ToList();
            }
        }
        public static List<Pool> buildGraphsXML(string filename)
        {
            using (XmlReader reader = XmlReader.Create(filename))
            {
                XElement root = XElement.Load(reader);
                XNamespace nsXmi = root.Attribute(XNamespace.Xmlns + "xmi").Value;
                XNamespace nsUml = root.Attribute(XNamespace.Xmlns + "uml").Value;
                XNamespace nsBPMN20 = root.Attribute(XNamespace.Xmlns + "BPMN2.0").Value;
                reader.Close();
                XElement superRoot = root.Element(nsUml + "Model");

                root = root.Element(nsUml + "Model").Element("packagedElement");
                var packageElements = (from pe in root.Element("packagedElement").Descendants("packagedElement")
                                       select pe).ToList();
                // obtaining groups of nodes (task, events, gates etc) 
                // group == elements in single pool
                List<XElement> groups = (from gr in root.Element("packagedElement").Elements("group")
                                         select gr).ToList();
                // Edges (Mostly ControlFlows)
                MultiDict<string, string> edgesControlFlow = extractEdges(root);

                MultiDict<string, Tuple<string, string>> edgesCF = extractEdgesX(root);
                // Activities
                Dictionary<string, Activity.ActivityType> activityTypes = getActivityTypes(superRoot, nsBPMN20);
                Dictionary<string, Activity> dictionaryActivities = extractActivitiesWithId(nsXmi, packageElements, activityTypes);
                // Filtering artifacts (Data objects) from packagedElements
                var artifacts = packageElements.Where(pElem => pElem.Attribute(nsXmi + "type").Value == "uml:Artifact").ToList();
                // TODO: incoming and outgoing - controlFlow
                var nodes = (from node in root.Element("packagedElement").Elements("node")
                             select node).ToList();
                Dictionary<string, DecisionNode.GateType> decisionNodesTypes = getDecisionNodeType(superRoot, nsBPMN20);
                Dictionary<string, DecisionNode> dictionaryDecisionNodes = extractDecisionNodes(nsXmi, nodes, decisionNodesTypes);

                // SendSignalAction
                Dictionary<string, SendSignalAction> dictionaryIntermediateEvents = new Dictionary<string, SendSignalAction>();
                Dictionary<string, SendSignalAction> dictionaryStartEvents = new Dictionary<string, SendSignalAction>();
                Dictionary<string, SendSignalAction> dictionaryEndEvents = new Dictionary<string, SendSignalAction>();

                Dictionary<string, SendSignalAction.EventType> sendSignalActionTypes = getSendSignalActionType(superRoot, nsBPMN20);
                var events = extractEventsWithId(nsXmi, nodes, sendSignalActionTypes);
                dictionaryStartEvents = events.Item1;
                dictionaryIntermediateEvents = events.Item2;
                dictionaryEndEvents = events.Item3;

                List<Pool> poolsToReturn = new List<Pool>();
                foreach (var group in groups)
                {
                    Pool pool = groupToGraphXML(group, nsXmi, dictionaryStartEvents,
                    dictionaryIntermediateEvents, dictionaryEndEvents, dictionaryActivities, dictionaryDecisionNodes,
                    edgesControlFlow, edgesCF);//, dictionaryInformationFlows);

                    string name = group.Attribute("name").Value;
                    poolsToReturn.Add(pool);
                }
                return poolsToReturn;
            }
        }
        private static Pool groupToGraphXML(XElement group, XNamespace ns,
            Dictionary<string, SendSignalAction> startEvents, Dictionary<string, SendSignalAction> intermediateEvents,
            Dictionary<string, SendSignalAction> endEvents, Dictionary<string, Activity> activities,
            Dictionary<string, DecisionNode> dictionaryDecisionNodes, MultiDict<string, string> edgesControlFlow,
            MultiDict<string, Tuple<string, string>> edgesCF)
        {
            string className = group.Attribute("name").Value;
            // startEvent
            // смотрим список node в этой группе и ищем startEvent
            List<string> ids = new List<string>();
            foreach (var node in group.Descendants("node"))
            {
                ids.Add(node.Attribute(ns + "idref").Value);
            }
            string startEventId = "";
            foreach (var startEvent in startEvents)
            {
                if (ids.Contains(startEvent.Key))
                {
                    startEventId = startEvent.Key;
                }
            }
            // Found startEvent, going on
            Dictionary<string, IDiagramObject> dict = new Dictionary<string, IDiagramObject>();
            foreach (var elem in (startEvents.Union(intermediateEvents).Union(endEvents)))
            {
                dict.Add(elem.Key, elem.Value);
            }
            foreach (var elem in activities)
                dict.Add(elem.Key, elem.Value);
            foreach (var elem in dictionaryDecisionNodes)
                dict.Add(elem.Key, elem.Value);

            List<Connection> resultXMI = new List<Connection>();
            List<string> visited = new List<string>();
            string currId = startEventId;
            recursiveBuildingOfGraphXML(currId, edgesControlFlow, edgesCF, resultXMI, dict, visited);          
            return new Pool(className, resultXMI);
        }
        private static void recursiveBuildingOfGraphXML(string currId, MultiDict<string, string> edgesControlFlow,
            MultiDict<string, Tuple<string, string>> edgesCF,
            List<Connection> currRes,
            Dictionary<string, IDiagramObject> dictionary, 
            List<string> visited)
        {
            var childs = edgesCF[currId];
            IDiagramObject currValue = dictionary[currId];
            DiagramElement type0 = detectType(currValue);
            if (childs != null)
            {
                foreach (var elem in childs)
                {
                    IDiagramObject value = dictionary[elem.Item1];
                    DiagramElement type1 = detectType(value);
                    if (dictionary[currId].GetType().Name != "DecisionNode")
                    {
                        string name = dictionary[currId].Name.Replace(" ", "") + "State";
                        string name1 = String.Format("{0}State", value.Name.Replace(" ", ""));

                        Connection connection = new Connection(currId, elem.Item1,
                            name, name1, "true",
                            type0, type1);
                        currRes.Add(connection);

                        visited.Add(currId);
                        if (!visited.Contains(elem.Item1))
                        {
                            recursiveBuildingOfGraphXML(elem.Item1, edgesControlFlow, edgesCF, currRes, dictionary, visited);
                        }
                    }
                    else
                    {
                        string name = String.Format("{0}State", dictionary[currId].Name.Replace(" ", ""));
                        string name1 = String.Format("{0}State", value.Name.Replace(" ", ""));

                        Connection connection = new Connection(currId, elem.Item1,
                            name, name1, String.Format("{0} == {1}", dictionary[currId].Name, elem.Item2), 
                            type0, type1);
                        currRes.Add(connection);
                        visited.Add(currId);
                        if (!visited.Contains(elem.Item1))
                        {
                            recursiveBuildingOfGraphXML(elem.Item1, edgesControlFlow, edgesCF, currRes, dictionary, visited);
                        }
                    }                    
                }
            }
        }
        /*
        /// <summary>
        /// Building trees of states
        /// </summary>
        /// <param name="filename">path to xmi file</param>
        /// <returns>list of pairs - key - name of entity, value - tree of states</returns>
        public static List<KeyValuePair<string, TreeNode<string>>> buildTrees(string filename)
        {
            //string filename = "c:\\Diploma\\Abiturients\\test.xml";
            using (XmlReader reader = XmlReader.Create(filename))
            {
                XElement root = XElement.Load(reader);
                XNamespace nsXmi = root.Attribute(XNamespace.Xmlns + "xmi").Value;
                XNamespace nsUml = root.Attribute(XNamespace.Xmlns + "uml").Value;
                XNamespace nsBPMN20 = root.Attribute(XNamespace.Xmlns + "BPMN2.0").Value;
                reader.Close();

                XElement superRoot = root.Element(nsUml + "Model");
                root = root.Element(nsUml + "Model").Element("packagedElement");
                var packageElements = (from pe in root.Descendants("packagedElement")
                                       select pe).ToList();
                // obtaining groups of nodes (task, events, gates etc) 
                // group == elements in single pool
                List<XElement> groups = (from gr in root.Element("packagedElement").Elements("group")
                                         select gr).ToList();
                // Edges (Mostly ControlFlows)
                MultiDict<string, string> edgesControlFlow = extractEdges(root);
                // Filtering information flows from packagedElements
                Dictionary<string, InformationFlow> dictionaryInformationFlows = extractInformationFlows(nsXmi, packageElements);
                // Activities
                Dictionary<string, Activity.ActivityType> activityTypes = getActivityTypes(root, nsBPMN20);
                Dictionary<string, Activity> dictionaryActivities = extractActivitiesWithId(nsXmi, packageElements, activityTypes);
                // Filtering artifacts (Data objects) from packagedElements
                var artifacts = packageElements.Where(pElem => pElem.Attribute(nsXmi + "type").Value == "uml:Artifact").ToList();
                // TODO: incoming and outgoing - controlFlow
                var nodes = (from node in root.Element("packagedElement").Elements("node")
                             select node).ToList();
                Dictionary<string, DecisionNode.GateType> decisionNodesTypes = getDecisionNodeType(root, nsBPMN20);
                Dictionary<string, DecisionNode> dictionaryDecisionNodes = extractDecisionNodes(nsXmi, nodes, decisionNodesTypes);

                // SendSignalAction
                Dictionary<string, SendSignalAction> dictionaryIntermediateEvents = new Dictionary<string, SendSignalAction>();
                Dictionary<string, SendSignalAction> dictionaryStartEvents = new Dictionary<string, SendSignalAction>();
                Dictionary<string, SendSignalAction> dictionaryEndEvents = new Dictionary<string, SendSignalAction>();

                Dictionary<string, SendSignalAction.EventType> sendSignalActionTypes = getSendSignalActionType(root, nsBPMN20);
                var events = extractEventsWithId(nsXmi, nodes, sendSignalActionTypes);
                dictionaryStartEvents = events.Item1;
                dictionaryIntermediateEvents = events.Item2;
                dictionaryEndEvents = events.Item3;

                List<KeyValuePair<string, TreeNode<string>>> treesOfStates = new List<KeyValuePair<string, TreeNode<string>>>();
                foreach (var group in groups)
                {
                    KeyValuePair<string, TreeNode<string>> nameTree = groupToTree(group, nsXmi, dictionaryStartEvents,
                    dictionaryIntermediateEvents, dictionaryEndEvents, dictionaryActivities, dictionaryDecisionNodes,
                    edgesControlFlow, dictionaryInformationFlows);

                    treesOfStates.Add(nameTree);
                }
                return treesOfStates;
                //Console.ReadKey();
            }
        }
        private static KeyValuePair<string, TreeNode<string>> groupToTree(XElement group, XNamespace ns,
            Dictionary<string, SendSignalAction> startEvents, Dictionary<string, SendSignalAction> intermediateEvents,
            Dictionary<string, SendSignalAction> endEvents, Dictionary<string, Activity> activities,
            Dictionary<string, DecisionNode> dictionaryDecisionNodes, MultiDict<string, string> edgesControlFlow,
            Dictionary<string, InformationFlow> dictionaryInformationFlows)
        {
            string className = group.Attribute("name").Value;
            // startEvent
            // смотрим список node в этой группе и ищем startEvent
            List<string> ids = new List<string>();
            foreach (var node in group.Descendants("node"))
            {
                ids.Add(node.Attribute(ns + "idref").Value);
            }
            string startEventId = "";
            foreach (var startEvent in startEvents)
            {
                if (ids.Contains(startEvent.Key))
                {
                    startEventId = startEvent.Key;
                }
            }
            // Found startEvent, going on
            Dictionary<string, IDiagramObject> dict = new Dictionary<string, IDiagramObject>();
            foreach (var elem in (startEvents.Union(intermediateEvents).Union(endEvents)))
            {
                dict.Add(elem.Key, elem.Value);
            }
            foreach (var elem in activities)
                dict.Add(elem.Key, elem.Value);
            foreach (var elem in dictionaryDecisionNodes)
                dict.Add(elem.Key, elem.Value);

            TreeNode<string> resultTree = new TreeNode<string>(startEvents[startEventId].Name.Replace(" ", String.Empty) + "State", DiagramElement.StartEvent);
            var currId = startEventId;
            List<string> visited = new List<string>();
            recursiveBuildingOfTree(currId, edgesControlFlow, resultTree, dict);
            deleteIsState(resultTree);
            KeyValuePair<string, TreeNode<string>> result = new KeyValuePair<string, TreeNode<string>>(className, resultTree);
            return result;
        }
         * */
        private static Dictionary<string, Activity> extractActivitiesWithId
            (XNamespace ns, 
            List<XElement> packageElements, 
            Dictionary<string, Activity.ActivityType> activityTypes)
        {
            var activities = packageElements.Where(pElem => pElem.Attribute(ns + "type").Value == "uml:Activity").ToList();
            Dictionary<string, Activity> dictionaryActivities = new Dictionary<string, Activity>();
            foreach (var activity in activities)
            {
                var id = activity.Attribute(ns + "id").Value;
                var name = activity.Attribute("name").Value;
                Activity.ActivityType type = activityTypes[id];
                dictionaryActivities.Add(id, new Activity(name, type));
            }
            return dictionaryActivities;
        }
        private static Tuple<Dictionary<string, SendSignalAction>,
            Dictionary<string, SendSignalAction>,
            Dictionary<string, SendSignalAction>> extractEventsWithId(XNamespace ns,
            List<XElement> nodes,
            Dictionary<string, SendSignalAction.EventType> sendSignalActionType)
        {
            var sendSignalActions = nodes.Where(node => node.Attribute(ns + "type").Value == "uml:SendSignalAction").ToList();
            Dictionary<string, SendSignalAction> dictionaryStartEvents = new Dictionary<string, SendSignalAction>();
            Dictionary<string, SendSignalAction> dictionaryIntermediateEvents = new Dictionary<string, SendSignalAction>();
            Dictionary<string, SendSignalAction> dictionaryEndEvents = new Dictionary<string, SendSignalAction>();

            foreach (var sendSignalAction in sendSignalActions)
            {
                var id = sendSignalAction.Attribute(ns + "id").Value;
                var list0 = (from dn in sendSignalAction.Elements("incoming")
                             select dn).Select(dn => dn.Attribute(ns + "idref").Value).ToList();
                var list1 = (from dn in sendSignalAction.Elements("outgoing")
                             select dn).Select(dn => dn.Attribute(ns + "idref").Value).ToList();

                SendSignalAction.EventType etype = sendSignalActionType[id];
                SendSignalAction sendSignalActionToAdd = new SendSignalAction(sendSignalAction.Attribute("name").Value, list0, list1, etype);
                // There are both incoming and outgoing flows
                // So it is an intermediate event
                if (list0.Count + list1.Count > 1)
                {
                    dictionaryIntermediateEvents.Add(id, sendSignalActionToAdd);
                }
                // There are no incoming flows (not a single one!)
                // Soooo... it is a start event
                else if (list0.Count == 0)
                {
                    dictionaryStartEvents.Add(id, sendSignalActionToAdd);
                }
                // No outgoing flows stands for end event
                else
                {
                    dictionaryEndEvents.Add(id, sendSignalActionToAdd);
                }
            }
            return new Tuple<Dictionary<string, SendSignalAction>,
                Dictionary<string, SendSignalAction>,
                Dictionary<string, SendSignalAction>>(dictionaryStartEvents, dictionaryIntermediateEvents, dictionaryEndEvents);
        }
        private static MultiDict<string, string> extractEdges(XElement root)
        {
            MultiDict<string, string> edgesControlFlow = new MultiDict<string, string>();
            var edges = from edge in root.Descendants("edge")
                        select edge;
            foreach (var edge in edges)
            {
                edgesControlFlow.Add(edge.Attribute("source").Value, edge.Attribute("target").Value);
            }
            return edgesControlFlow;
        }
        private static MultiDict<string, Tuple<string, string>> extractEdgesX(XElement root)
        {
            MultiDict<string, Tuple<string, string>> result = new MultiDict<string, Tuple<string, string>>();
            var edges = from edge in root.Descendants("edge")
                        select edge;
            foreach (var edge in edges)
            {
                string name = "";
                if (edge.Attribute("name") != null)
                {
                    name = edge.Attribute("name").Value;
                }
                Tuple<string, string> toAdd = new Tuple<string, string>(edge.Attribute("target").Value, name);
                result.Add(edge.Attribute("source").Value, toAdd);
            }
            return result;
        }
        private static Dictionary<string, InformationFlow> extractInformationFlows
            (XNamespace ns,
            List<XElement> packageElements,
            Dictionary<string, Activity.ActivityType> activityTypes,
            Dictionary<string, SendSignalAction.EventType> sendSignalActionTypes)
        {
            var informationFlows = packageElements.Where(pElem => pElem.Attribute(ns + "type").Value == "uml:InformationFlow").ToList();
            Dictionary<string, InformationFlow> dictionaryInformationFlows = new Dictionary<string, InformationFlow>();
            foreach (var elem in informationFlows)
            {
                var id = elem.Attribute(ns + "id").Value;
                var name = elem.Attribute("name").Value;
                var informationSource = elem.Attribute("informationSource").Value;
                var informationTarget = elem.Attribute("informationTarget").Value;

                DiagramElement sourceType = determineDiagramElementTypeById(informationSource, activityTypes, sendSignalActionTypes);
                DiagramElement targetType = determineDiagramElementTypeById(informationTarget, activityTypes, sendSignalActionTypes);

                InformationFlow infoFlow = new InformationFlow(name, informationSource, informationTarget, sourceType, targetType);
                dictionaryInformationFlows.Add(elem.Attribute(ns + "id").Value, infoFlow);
            }
            return dictionaryInformationFlows;
        }
        private static Dictionary<string, DecisionNode> extractDecisionNodes(XNamespace ns, 
            List<XElement> nodes,
            Dictionary<string, DecisionNode.GateType> decisionType)
        {
            var decisionNodes = nodes.Where(node => node.Attribute(ns + "type").Value == "uml:DecisionNode").ToList();
            Dictionary<string, DecisionNode> dictionaryDecisionNodes = new Dictionary<string, DecisionNode>();
            foreach (var decisionNode in decisionNodes)
            {
                var incomingIds = (from dn in decisionNode.Elements("incoming")
                             select dn).Select(dn => dn.Attribute(ns + "idref").Value).ToList();
                var outgoingIds = (from dn in decisionNode.Elements("outgoing")
                             select dn).Select(dn => dn.Attribute(ns + "idref").Value).ToList();
                string id = decisionNode.Attribute(ns + "id").Value;
                DecisionNode.GateType gtype = decisionType[id];

                if (decisionNode.Attribute("name") != null)
                {
                    dictionaryDecisionNodes.Add(id,
                        new DecisionNode(decisionNode.Attribute("name").Value, incomingIds, outgoingIds, gtype));
                }
                else
                {
                    dictionaryDecisionNodes.Add(id,
                        new DecisionNode("", incomingIds, outgoingIds, gtype));
                }
            }
            return dictionaryDecisionNodes;
        }     
        private static void deleteIsState(TreeNode<string> source)
        {
            List<TreeNode<string>> childrenNotReadOnly = source.ChildrenNotReadOnly;
            var toAdd = new List<TreeNode<string>>();
            var toRemove = new List<TreeNode<string>>();
            foreach (var elem in childrenNotReadOnly)   
            {
                if (elem.IsState == false)
                {
                    List<TreeNode<string>> childs = elem.ChildrenNotReadOnly;
                    toRemove.Add(elem);
                    foreach (var ch in childs)
                    {
                        toAdd.Add(ch);
                    }
                }
            }
            foreach (var toRem in toRemove)
            {
                source.ChildrenNotReadOnly.Remove(toRem);
            }
            source.ChildrenNotReadOnly.AddRange(toAdd);
            foreach (var elem in source.ChildrenNotReadOnly)
            {
                deleteIsState(elem);
            }
        }
        public static void createEnumOfStatesForGroup(XNamespace ns, XElement group,
            Dictionary<string, Activity> activities)
        {
            string className = group.Attribute("name").Value;
            var listOfValues = new List<string>();
            foreach (var node in group.Descendants("node"))
            {
                var idref = node.Attribute(ns + "idref").Value;
                if (activities.Keys.Contains(idref))
                {
                    listOfValues.Add(activities[idref].Name.Replace(" ", String.Empty) + "State");
                }
            }
            GenerateEnumOfStates generateEnumOfStates = new GenerateEnumOfStates(className, listOfValues);
            generateEnumOfStates.AddStates();
            generateEnumOfStates.GenerateCSharpCode();
        }
    }
}
