﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.IO;
using System.CodeDom;
using System.CodeDom.Compiler;
using Microsoft.CSharp;

namespace ParseXMIDocument
{
    /// <summary>
    /// This class generates enumof states
    /// </summary>
    public class GenerateEnumOfStates
    {
        /// <summary>
        /// Reference on assembly
        /// </summary>
        private readonly CodeCompileUnit targetUnit;
        /// <summary>
        /// Reference on enum
        /// </summary>
        private readonly CodeTypeDeclaration targetEnum;
        /// <summary>
        /// Name of enum
        /// </summary>
        private readonly string outputFileName;
        /// <summary>
        /// List of enum values
        /// </summary>
        private readonly List<string> names = new List<string>();
        /// <summary>
        /// Initializing of assembly and class, adding an appropriate declarations to CodeDOM graph
        /// </summary>
        /// <param name="filename">Name of object, whos states we enumerate</param> 
        public GenerateEnumOfStates(string filename, List<string> activityNames) 
        { 
            outputFileName = filename;
            names = activityNames;
            targetUnit = new CodeCompileUnit();
            CodeNamespace codeNamespace = new CodeNamespace(outputFileName + "Namespace");
            codeNamespace.Imports.Add(new CodeNamespaceImport("System"));
            targetEnum = new CodeTypeDeclaration(outputFileName + "State");
            targetEnum.IsEnum = true;
            targetEnum.TypeAttributes = TypeAttributes.Public;
            codeNamespace.Types.Add(targetEnum);
            targetUnit.Namespaces.Add(codeNamespace);
        }
        /// <summary>
        /// Addition of state to enum
        /// </summary>
        public void AddStates()
        {
            foreach (var name in names)
            {
                CodeMemberField codeMemberField = new CodeMemberField();
                codeMemberField.Attributes = MemberAttributes.Private;
                codeMemberField.Name = name;
                codeMemberField.Type = new CodeTypeReference(typeof(System.String));
                codeMemberField.Comments.Add(new CodeCommentStatement(name + " attribute"));
                targetEnum.Members.Add(codeMemberField);
            }
        }
        /// <summary>
        /// Generate CSharp source code from the compile unit.
        /// </summary>
        /// <param name="filename">Output file name</param>
        public void GenerateCSharpCode()
        {
            using (CodeDomProvider provider = CodeDomProvider.CreateProvider("CSharp"))
            {
                CodeGeneratorOptions options = new CodeGeneratorOptions();
                options.BracingStyle = "C";
                using (StreamWriter sourceWriter = new StreamWriter(outputFileName + ".cs"))
                {
                    provider.GenerateCodeFromCompileUnit(targetUnit, sourceWriter, options);
                }
            }
        }
    }
}
