﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.IO;
using System.CodeDom;
using System.CodeDom.Compiler;
using Microsoft.CSharp;
namespace FormGenerator.Repository
{
    class GenerateStaticClass
    {
        /// <summary>
        /// Reference on assembly
        /// </summary>
        private readonly CodeCompileUnit targetUnit;
        /// <summary>
        /// Reference on class
        /// </summary>
        private readonly CodeTypeDeclaration targetClass;
        /// <summary>
        /// Name of class
        /// </summary>
        private readonly string outputFileName;
        public GenerateStaticClass(string filename) 
        { 
            outputFileName = filename;
            targetUnit = new CodeCompileUnit();
            CodeNamespace codeNamespace = new CodeNamespace(outputFileName + "Namespace");
            codeNamespace.Imports.Add(new CodeNamespaceImport("System"));
            targetClass = new CodeTypeDeclaration(outputFileName);
            targetClass.IsClass = true;
            targetClass.TypeAttributes = TypeAttributes.Public | TypeAttributes.Sealed | TypeAttributes.Abstract;
            codeNamespace.Types.Add(targetClass);
            targetUnit.Namespaces.Add(codeNamespace);
        }
        public void AddField()
        {
            CodeMemberField status = new CodeMemberField();
            status.Attributes = MemberAttributes.Private | MemberAttributes.Static;
            status.Name = "status";
            status.Type = new CodeTypeReference(typeof(System.String));
            status.Comments.Add(new CodeCommentStatement(
                "Current status of " + outputFileName));
            targetClass.Members.Add(status); 
        }
        public void AddProperties()
        {
            // Declare the Status property.
            CodeMemberProperty status = new CodeMemberProperty();
            status.Attributes =
                MemberAttributes.Public | MemberAttributes.Static;
            status.Name = "Status";
            status.HasGet = true;
            status.HasSet = true;
            status.Type = new CodeTypeReference(typeof(System.String));
            status.Comments.Add(new CodeCommentStatement(
                "The Status property"));
            status.GetStatements.Add(new CodeMethodReturnStatement(
                new CodeFieldReferenceExpression(
                new CodeThisReferenceExpression(), "status")));
            status.SetStatements.Add(new CodeAssignStatement(new CodeFieldReferenceExpression(new CodeThisReferenceExpression(), "status"),
                new CodePropertySetValueReferenceExpression()));
            targetClass.Members.Add(status); 
        }
        public void GenerateCSharpCode()
        {
            using (CodeDomProvider provider = CodeDomProvider.CreateProvider("CSharp"))
            {
                CodeGeneratorOptions options = new CodeGeneratorOptions();
                options.BracingStyle = "C";
                using (StreamWriter sourceWriter = new StreamWriter(outputFileName + ".cs"))
                {
                    provider.GenerateCodeFromCompileUnit(targetUnit, sourceWriter, options);
                }
            }
        }
    }
}
