﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class Tree:List
    {
        public Tree(string name, string logicName, Class c, bool isAuxiliary)
            : base(name, logicName, c, isAuxiliary)
        {
        }
        public Tree(XElement xelement)
            : base(xelement)
        {

        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("Tree",
                    new XAttribute("Name", this.Name),
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("Card", (this.Card != null) ? this.Card.Name : ""),
                    new XAttribute("Locator", (this.Locator != null) ? this.Locator.Name : ""),
                    new XElement("Root", this.ListTreeRoot.XElement),
                    new XAttribute("IsAux", this.IsAuxiliary),
                    new XAttribute("Folder", this.Folder == null ? "" : this.Folder.Path),
                    new XAttribute("View", (this.View != null) ? this.View.LogicName : ""));

                return xelement;
            }
        }  


    }
}
