﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class CardFieldSimple:CardField
    {
        private Field field;
        /// <summary>
        /// Multi-line textbox, ...
        /// </summary>
        private String additional;

        public String Additional
        {
            get { return additional; }
            set { additional = value; }
        }

        public const string MULTILINE = "Multiline";

        public CardFieldSimple(Field field,string logicName){
            this.field = field;
            LogicName = logicName;

        }

        public CardFieldSimple(Class c, XElement xelement)
        {
            LogicName = xelement.Attribute("LogicName").Value;
            field = Repository.Instance.GetClassField(c, xelement.Attribute("Field").Value);
            if (xelement.Attribute("Additional") != null)
            {
                additional = xelement.Attribute("Additional").Value;
            }
            else
            {
                additional = null;
            }
        }

        public Field Field
        {
            get { return field; }
            set { field = value; }
        }

        public override String Name
        {
            get { return field.Name; }
        }

        public override XElement XElement
        {
            get
            {
                XElement xelement = new XElement("CardFieldSimple",
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("Field", this.Field.Name));

                if (additional != null)
                {
                    xelement.SetAttributeValue("Additional", this.additional);
                }

                return xelement;
            }
        }     


    }
}
