﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using FormGenerator.Forms;

namespace FormGenerator.Generate
{
    public class RelationshipGenerator:Generator
    {

       

        private ManyToManyRelationship relation;
       
        public RelationshipGenerator(ManyToManyRelationship relation )
        {
            this.relation = relation;
          
        }
        
        public void Generate(string path)
        {
            //move to copy
            string fromPath = Application.StartupPath + "\\Templates\\Relation.cs";
            string toPath = path + "\\" + relation.Name + ".cs";
            Directory.CreateDirectory(path);
            File.Copy(fromPath, toPath, true);

            ReplaceInFile(toPath, "ZZFormNameZZ", relation.Name);
            ReplaceInFile(toPath, "ZZFormLogicNameZZ", relation.LogicName);

            ReplaceInFile(toPath, "ZZMemberClassNameZZ", DatabaseGenerator.getSqlTableName(relation.MemberRelation.MasterClass.Name));
            ReplaceInFile(toPath, "ZZIntermediateClassNameZZ", DatabaseGenerator.getSqlTableName(relation.IntermediateClass.Name));
            ReplaceInFile(toPath, "ZZPartyClassNameZZ", DatabaseGenerator.getSqlTableName(relation.PartyRelation.MasterClass.Name));

            ReplaceInFile(toPath, "ZZPartyFieldNameZZ", DatabaseGenerator.getSqlFieldName(relation.PartyClassField.Name));
            ReplaceInFile(toPath, "ZZMemberFieldLogicNameZZ", relation.MemberClassField.LogicName);
            ReplaceInFile(toPath, "ZZMemberFieldNameZZ", DatabaseGenerator.getSqlFieldName(relation.MemberClassField.Name));

            ReplaceInFile(toPath, "ZZFixedTableLabelZZ", relation.PartyRelation.MasterClass.LogicName);
            
            


            //File.Copy(fromPath, toPath, true);
        }
    }
}
